/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.recipes;

import com.google.common.collect.Maps;
import com.legacy.glacidus.blocks.BlocksGlacidus;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SolidifierRecipes {
    public static final SolidifierRecipes INSTANCE = new SolidifierRecipes();
    private final Map<ItemStack, ItemStack> liquefierList = Maps.newHashMap();

    private SolidifierRecipes() {
        this.addSolidifierRecipe(BlocksGlacidus.thawed_antinatric_stone, new ItemStack(BlocksGlacidus.frozen_antinatric_stone));
        this.addSolidifierRecipe(Items.field_151131_as, new ItemStack(Blocks.field_150432_aD));
        this.addSolidifierRecipe(Blocks.field_150432_aD, new ItemStack(Blocks.field_150403_cj));
        this.addSolidifierRecipe(Items.field_151129_at, new ItemStack(Blocks.field_150343_Z));
    }

    public void addSolidifierRecipe(Block input, ItemStack stack) {
        this.addSolidifierRecipe(Item.func_150898_a((Block)input), stack);
    }

    public void addSolidifierRecipe(Item input, ItemStack stack) {
        this.addSolidifierRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack);
    }

    public void addSolidifierRecipe(ItemStack input, ItemStack stack) {
        this.liquefierList.put(input, stack);
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.liquefierList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.liquefierList;
    }

    public static SolidifierRecipes instance() {
        return INSTANCE;
    }
}

