/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.recipes;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LiquefierRecipes {
    public static final LiquefierRecipes INSTANCE = new LiquefierRecipes();
    private final Map<ItemStack, ItemStack> liquefierList = Maps.newHashMap();

    private LiquefierRecipes() {
    }

    public void addLiquefierRecipe(Block input, ItemStack stack) {
        this.addLiquefierRecipe(Item.func_150898_a((Block)input), stack);
    }

    public void addLiquefierRecipe(Item input, ItemStack stack) {
        this.addLiquefierRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack);
    }

    public void addLiquefierRecipe(ItemStack input, ItemStack stack) {
        this.liquefierList.put(input, stack);
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.liquefierList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.liquefierList;
    }

    public static LiquefierRecipes instance() {
        return INSTANCE;
    }
}

