/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.player;

import com.legacy.glacidus.player.PlayerCapability;
import com.legacy.glacidus.player.PlayerRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class PlayerCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    private PlayerCapability capability;

    public PlayerCapabilityProvider(EntityPlayer player) {
        this.capability = new PlayerCapability(player);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == PlayerRegistry.PLAYER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == PlayerRegistry.PLAYER_CAPABILITY) {
            return (T)this.capability;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.capability != null) {
            this.capability.writeCapabilityToNBT(compound);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (this.capability != null) {
            this.capability.readCapabilityFromNBT(compound);
        }
    }
}

