/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.entities.hostile;

import com.legacy.glacidus.blocks.BlocksGlacidus;
import com.legacy.glacidus.blocks.material.GlacidusMaterial;
import com.legacy.glacidus.client.sounds.GlacidusSounds;
import com.legacy.glacidus.items.ItemsGlacidus;
import com.legacy.glacidus.loottables.GlacidusLootTables;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMorprous
extends EntityMob {
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityMorprous.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityMorprous.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private boolean isBreakDoorsTaskSet;
    private float zombieWidth = -1.0f;
    private float zombieHeight;
    public boolean isAngry;

    public EntityMorprous(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public boolean isBreakDoorsTaskSet() {
        return this.isBreakDoorsTaskSet;
    }

    public void setBreakDoorsAItask(boolean enabled) {
        if (this.isBreakDoorsTaskSet != enabled) {
            this.isBreakDoorsTaskSet = enabled;
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
            if (enabled) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(BABY_SPEED_BOOST);
            if (childZombie) {
                iattributeinstance.func_111121_a(BABY_SPEED_BOOST);
            }
        }
        this.setChildSize(childZombie);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.shouldBurnInDay() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        double d = this.field_70146_Z.nextFloat() - 0.3f;
        double d1 = this.field_70146_Z.nextFloat();
        double d2 = this.field_70146_Z.nextFloat() - 0.3f;
        double d3 = this.field_70165_t + d * d1;
        double d4 = this.func_174813_aQ().field_72338_b + d1 + 0.3;
        double d5 = this.field_70161_v + d2 * d1 - (double)0.2f;
        this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, d3, d4 - 0.3, d5, 0.0, (double)-0.075f, 0.0, new int[0]);
        this.isAngry = this.func_70638_az() != null;
        super.func_70636_d();
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return GlacidusSounds.MORPROUS_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GlacidusSounds.MORPROUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GlacidusSounds.MORPROUS_DEATH;
    }

    protected SoundEvent getStepSound() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GlacidusLootTables.surface_mob;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsGlacidus.eukeite_sword));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsGlacidus.antinatric_sword));
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        compound.func_74757_a("CanBreakDoors", this.isBreakDoorsTaskSet());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        this.setBreakDoorsAItask(compound.func_74767_n("CanBreakDoors"));
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && blockpos.func_177956_o() >= 73 && this.func_70814_o() && super.func_70601_bi() && this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == BlocksGlacidus.frozen_antinatric_stone && this.field_70146_Z.nextInt(15) == 0;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(stack);
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    public void func_70645_a(DamageSource cause) {
        EntityCreeper entitycreeper;
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityCreeper && (entitycreeper = (EntityCreeper)cause.func_76346_g()).func_70830_n() && entitycreeper.func_70650_aV()) {
            entitycreeper.func_175493_co();
            ItemStack itemstack = this.getSkullDrop();
            if (!itemstack.func_190926_b()) {
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    protected ItemStack getSkullDrop() {
        return new ItemStack(Items.field_151144_bL, 1, 2);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70072_I() {
        if (this.func_184187_bx() instanceof EntityBoat) {
            this.field_70171_ac = false;
        } else if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, (double)-0.4f, 0.0).func_186664_h(0.001), GlacidusMaterial.GLACIUM, (Entity)this)) {
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild;

        private GroupData(boolean p_i47328_2_) {
            this.isChild = p_i47328_2_;
        }
    }
}

