/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.client.sounds;

import com.legacy.glacidus.GlacidusConfig;
import com.legacy.glacidus.client.sounds.GlacidusSounds;
import com.legacy.glacidus.client.sounds.ambient.LayerAmbientSound;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GlacidusMusicHandler
implements ITickable {
    private final Random rand = new Random();
    public final Minecraft mc;
    public ISound currentMusic;
    public ISound playingRecord;
    private boolean ambienceMusicPlaying;
    private LayerAmbientSound topLayerAmbience;
    private int timeUntilNextMusic = 100;
    private static GlacidusMusicHandler INSTANCE;

    public GlacidusMusicHandler(Minecraft mcIn) {
        this.mc = mcIn;
        this.topLayerAmbience = new LayerAmbientSound(null, GlacidusSounds.AMBIENT_WIND_HUM, 0);
    }

    public static GlacidusMusicHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlacidusMusicHandler(Minecraft.func_71410_x());
        }
        return INSTANCE;
    }

    public void func_73660_a() {
        if (this.mc.field_71439_g != null && !this.mc.func_147118_V().func_147692_c(this.playingRecord)) {
            if (!this.mc.func_147118_V().func_147692_c((ISound)this.topLayerAmbience) && this.ambienceMusicPlaying) {
                this.mc.func_147118_V().func_147683_b((ISound)this.topLayerAmbience);
                this.topLayerAmbience = new LayerAmbientSound((EntityPlayer)this.mc.field_71439_g, GlacidusSounds.AMBIENT_WIND_HUM, 0);
                this.ambienceMusicPlaying = false;
                return;
            }
            if (this.topLayerAmbience.func_147667_k() && this.ambienceMusicPlaying) {
                this.topLayerAmbience.resetSong();
                this.ambienceMusicPlaying = false;
            }
            if (this.mc.field_71439_g != null) {
                this.topLayerAmbience.setPlayer((EntityPlayer)this.mc.field_71439_g);
                if (!this.ambienceMusicPlaying && this.topLayerAmbience.canPlay()) {
                    if (this.mc.func_147118_V().func_147692_c((ISound)this.topLayerAmbience)) {
                        this.mc.func_147118_V().func_147683_b((ISound)this.topLayerAmbience);
                        this.topLayerAmbience = new LayerAmbientSound((EntityPlayer)this.mc.field_71439_g, GlacidusSounds.AMBIENT_WIND_HUM, 0);
                        this.ambienceMusicPlaying = false;
                        return;
                    }
                    if (!this.mc.func_147118_V().func_147692_c((ISound)this.topLayerAmbience)) {
                        this.mc.func_147118_V().func_147682_a((ISound)this.topLayerAmbience);
                    }
                    this.ambienceMusicPlaying = true;
                }
            }
            MusicType musicticker$musictype = this.getRandomMusicType();
            if (this.currentMusic != null) {
                if (this.mc.field_71439_g != null && this.mc.field_71439_g.field_71093_bK != GlacidusConfig.dimension.dimensionID) {
                    this.mc.func_147118_V().func_147683_b(this.currentMusic);
                    this.timeUntilNextMusic = MathHelper.func_76136_a((Random)this.rand, (int)0, (int)(musicticker$musictype.getMinDelay() / 2));
                }
                if (!this.mc.func_147118_V().func_147692_c(this.currentMusic)) {
                    this.currentMusic = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)musicticker$musictype.getMinDelay(), (int)musicticker$musictype.getMaxDelay()), this.timeUntilNextMusic);
                }
            }
            this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, musicticker$musictype.getMaxDelay());
            if (this.currentMusic == null && this.mc.field_71439_g != null && this.mc.field_71439_g.field_71093_bK == GlacidusConfig.dimension.dimensionID && this.timeUntilNextMusic-- <= 0) {
                this.playMusic(musicticker$musictype);
            }
        }
    }

    public boolean isMusicPlaying() {
        boolean flag = false;
        for (MusicType value : MusicType.values()) {
            flag = this.playingMusic(value);
        }
        return flag;
    }

    public void playMusic(MusicType requestedMusicType) {
        this.currentMusic = requestedMusicType.getSound();
        this.mc.func_147118_V().func_147682_a(this.currentMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    private boolean playingMusic(MusicType musicType) {
        return this.mc.func_147118_V().func_147692_c(musicType.getSound());
    }

    private MusicType getRandomMusicType() {
        return MusicType.values()[this.rand.nextInt(10)];
    }

    public void stopMusic() {
        if (this.currentMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.currentMusic);
            this.currentMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ISound getAchievementSound(int number) {
        SoundEvent sound = GlacidusSounds.RANDOM_ADVANCEMENT_JINGLE;
        return new PositionedSoundRecord(sound.func_187503_a(), SoundCategory.PLAYERS, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static enum MusicType {
        GoodbyePlanet((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_ONE), 1500, 4400),
        Lumicia((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_SIX), 1500, 4400),
        Antinatric((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_NINE), 1500, 4400),
        Crysium((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_ELEVEN), 1500, 4400),
        Indigo((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_TWO), 1500, 4400),
        Decipher((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_TEN), 1500, 4400),
        Underground((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_THREE), 1500, 4400),
        SicutTerrae((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_FOUR), 1500, 4400),
        Mitescere((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_FIVE), 1500, 4400),
        Oxygen((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_EIGHT), 1500, 4400),
        Dromada((ISound)PositionedSoundRecord.func_184370_a((SoundEvent)GlacidusSounds.MUSIC_TRACK_SEVEN), 1500, 4400);

        private final ISound sound;
        private final int minDelay;
        private final int maxDelay;

        private MusicType(ISound soundIn, int minDelayIn, int maxDelayIn) {
            this.sound = soundIn;
            this.minDelay = minDelayIn;
            this.maxDelay = maxDelayIn;
        }

        public ISound getSound() {
            return this.sound;
        }

        public int getMinDelay() {
            return this.minDelay;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }
    }
}

