/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.client;

import com.legacy.glacidus.CommonProxy;
import com.legacy.glacidus.client.ClientEventHandler;
import com.legacy.glacidus.client.GlacidusFluidModelLoader;
import com.legacy.glacidus.client.gui.GuiGlacidusToast;
import com.legacy.glacidus.client.renders.BlockRenders;
import com.legacy.glacidus.client.renders.EntityRenders;
import com.legacy.glacidus.client.renders.ItemRenders;
import com.legacy.glacidus.util.GlacidusUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ClientProxy
extends CommonProxy {
    private ClientEventHandler clientEventHandler;

    @Override
    public ClientEventHandler getClientEventHandler() {
        return this.clientEventHandler;
    }

    @Override
    public void preInitialization() {
        GlacidusUtils.registerEvent(new BlockRenders());
        GlacidusUtils.registerEvent(new ItemRenders());
        GuiGlacidusToast.overrideToastGui();
        EntityRenders.initialization();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new GlacidusFluidModelLoader());
    }

    @Override
    public void initialization() {
        this.clientEventHandler = new ClientEventHandler();
        GlacidusUtils.registerEvent(this.clientEventHandler);
    }

    @Override
    public EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public void handleLightMapColor(float partialTicks, float[] colors) {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            if (player.field_70163_u > 74.0) {
                colors[0] = colors[0] + 0.1f;
                colors[1] = colors[1] + 0.05f;
                colors[2] = colors[2] + 0.15f;
            } else if (player.field_70163_u > 26.0) {
                float light = 0.05f;
                colors[0] = colors[0] + light + 0.1f;
                colors[1] = colors[1] + light + 0.05f;
                colors[2] = colors[2] + light + 0.15f;
            } else {
                float light = 0.2f;
                colors[0] = colors[0] + light + light / 2.0f + 0.3f;
                colors[1] = colors[1] + light + 0.0f;
                colors[2] = colors[2] + light + 0.0f;
            }
        }
    }
}

