/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.client;

import com.legacy.glacidus.Glacidus;
import com.legacy.glacidus.GlacidusConfig;
import com.legacy.glacidus.client.gui.errors.GuiOptifineError;
import com.legacy.glacidus.client.sounds.GlacidusMusicHandler;
import com.legacy.glacidus.client.sounds.ambient.LayerAmbientSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import paulscode.sound.SoundSystem;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    private float musicVolume;
    private float dimTimeInSeconds;
    private long timeAtDim;
    private boolean dimming;
    private String sound;
    private SoundManager sndManager;
    public static boolean warnCTM = true;

    public ClientEventHandler() {
        this.musicVolume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MUSIC);
    }

    public void dimMusic(float dimTimeInSeconds) {
        this.musicVolume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MUSIC);
        this.dimTimeInSeconds = dimTimeInSeconds;
        this.timeAtDim = System.currentTimeMillis();
        this.dimming = true;
    }

    @SubscribeEvent
    public static void onOpenGui(GuiOpenEvent event) {
        if (!FMLClientHandler.instance().hasOptifine() && !Loader.isModLoaded((String)"ctm") && event.getGui() instanceof GuiMainMenu && warnCTM) {
            event.setGui((GuiScreen)new GuiOptifineError(event.getGui()));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().func_147113_T()) {
            if (this.dimming) {
                long current = System.currentTimeMillis();
                long dif = current - this.timeAtDim;
                if ((double)dif / 1000.0 >= (double)this.dimTimeInSeconds) {
                    this.dimming = false;
                }
                this.musicVolume = Math.max(Math.max(0.0f, Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MUSIC) * 0.05f), this.musicVolume * 0.95f);
            } else {
                this.musicVolume = Math.min(Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MUSIC), this.musicVolume * 1.05f);
            }
            GlacidusMusicHandler.getInstance().func_73660_a();
            if (this.sndManager == null) {
                this.sndManager = (SoundManager)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (String[])new String[]{"field_147694_f", "sndManager"});
            }
            if (this.sound != null) {
                try {
                    ((SoundSystem)ObfuscationReflectionHelper.getPrivateValue(SoundManager.class, (Object)this.sndManager, (String[])new String[]{"field_148620_e", "sndSystem"})).setVolume(this.sound, this.musicVolume);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void onSoundPlayed(PlayStreamingSourceEvent event) {
        SoundCategory category = event.getSound().func_184365_d();
        EntityPlayer player = Glacidus.proxy.getPlayer();
        if (player != null && player.field_71093_bK == GlacidusConfig.dimension.dimensionID && category == SoundCategory.MUSIC && event.getSound().func_147650_b().func_110624_b().equals("glacidus")) {
            this.sound = event.getUuid();
        }
    }

    @SubscribeEvent
    public void onSoundPlayed(PlaySoundEvent event) {
        SoundCategory category = event.getSound().func_184365_d();
        EntityPlayer player = Glacidus.proxy.getPlayer();
        GlacidusMusicHandler musicHandler = GlacidusMusicHandler.getInstance();
        if (player != null && player.field_71093_bK == GlacidusConfig.dimension.dimensionID) {
            if (category == SoundCategory.MUSIC) {
                if (!event.getSound().func_147650_b().func_110624_b().equals("glacidus") || musicHandler.isMusicPlaying() && !(event.getSound() instanceof LayerAmbientSound)) {
                    event.setResultSound(null);
                }
            } else if (category == SoundCategory.RECORDS) {
                musicHandler.stopMusic();
                musicHandler.currentMusic = null;
                musicHandler.playingRecord = event.getSound();
                return;
            }
        }
    }
}

