/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.blocks.natural;

import com.legacy.glacidus.blocks.BlocksGlacidus;
import com.legacy.glacidus.blocks.material.GlacidusMaterial;
import com.legacy.glacidus.client.sounds.GlacidusSounds;
import com.legacy.glacidus.entities.hostile.EntityFrigispitor;
import com.legacy.glacidus.entities.hostile.EntityMorprous;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlaciumStatic
extends BlockFluidClassic {
    protected int tickRate = 3;

    public BlockGlaciumStatic() {
        super(BlocksGlacidus.GLACIUM, GlacidusMaterial.GLACIUM);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityMorprous) && !(entityIn instanceof EntityFrigispitor)) {
            entityIn.field_70181_x += (double)0.2f;
            entityIn.func_70097_a(new DamageSource("glacium_frosted"), 7.0f);
        }
    }

    protected void triggerMixEffects(World worldIn, BlockPos pos) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SNOWBALL, d0 + Math.random(), d1 + 1.2, d2 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean checkForMixing(World worldIn, BlockPos pos, IBlockState state) {
        if (this.field_149764_J == GlacidusMaterial.GLACIUM) {
            boolean lava = false;
            boolean water = false;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                if (enumfacing != EnumFacing.DOWN && worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_185904_a() == Material.field_151587_i) {
                    lava = true;
                    break;
                }
                if (enumfacing == EnumFacing.DOWN || worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_185904_a() != Material.field_151586_h) continue;
                water = true;
                break;
            }
            if (lava) {
                Integer integer = (Integer)state.func_177229_b((IProperty)LEVEL);
                if (integer == 0) {
                    worldIn.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                    this.triggerMixEffects(worldIn, pos);
                    return true;
                }
                if (integer <= 4) {
                    worldIn.func_175656_a(pos, BlocksGlacidus.thawed_antinatric_stone.func_176223_P());
                    this.triggerMixEffects(worldIn, pos);
                    return true;
                }
            }
            if (water) {
                worldIn.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
                this.triggerMixEffects(worldIn, pos);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            double d6;
            double d4;
            double d8;
            if (rand.nextInt(100) == 0) {
                d8 = d0 + (double)rand.nextFloat();
                d4 = d1 + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e;
                d6 = d2 + (double)rand.nextFloat();
                if (rand.nextInt(400) == 0) {
                    worldIn.func_184134_a(d8, d4, d6, GlacidusSounds.BLOCK_GLACIUM_POP, SoundCategory.BLOCKS, 0.3f + rand.nextFloat() * 0.6f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
            }
            if (rand.nextInt(400) == 0) {
                worldIn.func_184134_a(d0, d1, d2, GlacidusSounds.BLOCK_GLACIUM_AMBIENT, SoundCategory.BLOCKS, 0.3f + rand.nextFloat() * 0.6f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(30) == 0) {
                d8 = d0 + (double)rand.nextFloat();
                d4 = d1 + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e;
                d6 = d2 + (double)rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.CLOUD, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForMixing(worldIn, pos, state);
        if (pos.func_177956_o() == 27) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForMixing(worldIn, pos, state);
        if (pos.func_177956_o() == 27) {
            worldIn.func_175698_g(pos);
        }
    }

    public static float getLiquidHeightPercent(int meta) {
        if (meta >= 8) {
            meta = 0;
        }
        return (float)(meta + 1) / 9.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        Vec3d viewport = ActiveRenderInfo.func_178806_a((Entity)entity, (double)partialTicks);
        if (state.func_185904_a().func_76224_d()) {
            float f1;
            float height = 0.0f;
            if (state.func_177230_c() instanceof BlockLiquid) {
                height = BlockGlaciumStatic.getLiquidHeightPercent((Integer)state.func_177229_b((IProperty)LEVEL)) - 0.11111111f;
            }
            if (viewport.field_72448_b > (double)(f1 = (float)(pos.func_177956_o() + 1) - height)) {
                BlockPos upPos = pos.func_177984_a();
                IBlockState upState = world.func_180495_p(upPos);
                return upState.func_177230_c().getFogColor(world, upPos, upState, entity, originalColor, partialTicks);
            }
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }
}

