/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.zawamod.init.ZAWABlocks;
import org.zawamod.world.GeneratedFlower;
import org.zawamod.world.struct.WorldGenArcticGrass;
import org.zawamod.world.struct.WorldGenCoral;
import org.zawamod.world.struct.WorldGenKelp;
import org.zawamod.world.struct.WorldGenMixedStones;
import org.zawamod.world.struct.WorldGenMossyRiverStones;
import org.zawamod.world.struct.WorldGenOceanCluster;
import org.zawamod.world.struct.WorldGenRiverStones;
import org.zawamod.world.struct.WorldGenSeaGrass;
import org.zawamod.world.struct.WorldGenZAWAFlower;

public class ZAWAWorldGenerator
implements IWorldGenerator {
    public static List<GeneratedFlower> generations = Lists.newArrayList();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworld(world, random, blockX, blockZ);
            }
        }
    }

    public static void initList() {
        generations.add(new GeneratedFlower("Sea Grass", new WorldGenSeaGrass(), 8, Biomes.field_76771_b, Biomes.field_76777_m, Biomes.field_150575_M));
        generations.add(new GeneratedFlower("Kelp", new WorldGenKelp(), 1, Biomes.field_76771_b, Biomes.field_76781_i, Biomes.field_150575_M));
        generations.add(new GeneratedFlower("Dried Bamboo", new WorldGenZAWAFlower(ZAWABlocks.DRIED_BAMBOO), 4, Biomes.field_150588_X, Biomes.field_76767_f));
        generations.add(new GeneratedFlower("Bamboo", new WorldGenZAWAFlower(ZAWABlocks.BAMBOO), 4, Biomes.field_76782_w, Biomes.field_76780_h, Biomes.field_76770_e));
        generations.add(new GeneratedFlower("Artic Moss", new WorldGenZAWAFlower(ZAWABlocks.ARCTIC_MOSS), 4, Biomes.field_76768_g, Biomes.field_76770_e, Biomes.field_76775_o));
        generations.add(new GeneratedFlower("Golden Sparks", new WorldGenZAWAFlower(ZAWABlocks.GOLDEN_SPARKS), 4, Biomes.field_150585_R, Biomes.field_76767_f, Biomes.field_76772_c));
        generations.add(new GeneratedFlower("Temple Bells", new WorldGenZAWAFlower(ZAWABlocks.TEMPLE_BELLS), 4, Biomes.field_150588_X, Biomes.field_76769_d, Biomes.field_150589_Z));
        generations.add(new GeneratedFlower("Peach Bells", new WorldGenZAWAFlower(ZAWABlocks.PEACH_FLOWER), 4, Biomes.field_76767_f, Biomes.field_150585_R));
        generations.add(new GeneratedFlower("Wild Celery", new WorldGenZAWAFlower(ZAWABlocks.WILD_CELERY), 4, Biomes.field_76780_h, Biomes.field_76782_w, Biomes.field_76783_v));
        generations.add(new GeneratedFlower("Bellflowers", new WorldGenZAWAFlower(ZAWABlocks.BELLFLOWERS), 4, Biomes.field_150588_X, Biomes.field_76772_c));
        generations.add(new GeneratedFlower("Ostritch Fern", new WorldGenZAWAFlower(ZAWABlocks.OSTRITCH_FERN), 4, Biomes.field_76772_c, Biomes.field_76767_f, Biomes.field_76782_w));
        generations.add(new GeneratedFlower("Bromeliad", new WorldGenZAWAFlower(ZAWABlocks.BROMELIAD), 4, Biomes.field_76780_h, Biomes.field_76782_w));
        generations.add(new GeneratedFlower("Ocean Custer", new WorldGenOceanCluster(), 2, Biomes.field_76771_b, Biomes.field_76787_r, Biomes.field_150575_M));
        generations.add(new GeneratedFlower("Arctic Grass", new WorldGenArcticGrass(), 2, Biomes.field_76774_n));
        generations.add(new GeneratedFlower("Coral", new WorldGenCoral(), 1, Biomes.field_76771_b, Biomes.field_76787_r, Biomes.field_150575_M));
        generations.add(new GeneratedFlower("River Stones", new WorldGenRiverStones(), 1, Biomes.field_76781_i));
        generations.add(new GeneratedFlower("Mossy River Stones", new WorldGenMossyRiverStones(), 1, Biomes.field_76781_i));
        generations.add(new GeneratedFlower("Mixed Stones", new WorldGenMixedStones(), 1, Biomes.field_76770_e));
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(blockX, 64, blockZ));
        for (GeneratedFlower generation : generations) {
            generation.runGeneration(world, rand, blockX, blockZ);
        }
    }

    public static int findRestingPlace(World world, int x, int z) {
        for (int y = world.func_72800_K(); y >= 0; --y) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            if (world.func_180495_p(new BlockPos(x, y - 1, z)).func_185904_a() == Material.field_151579_a || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151584_j || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151582_l) continue;
            return y;
        }
        return -1;
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        for (int y = world.func_72800_K(); y >= 0; --y) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151587_i || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151579_a || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151584_j || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151582_l) continue;
            return y;
        }
        return -1;
    }
}

