/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.Gender;

public class ZAWAUtils {
    public static final int GLOBAL_NO_VALUE = -1;

    public static boolean entityWithinArea(Entity e, BlockPos starting, int bounds) {
        for (int i = -bounds; i < bounds; ++i) {
            for (int j = -bounds; j < bounds; ++j) {
                if ((int)e.field_70165_t != starting.func_177982_a(i, 0, j).func_177958_n() || (int)e.field_70161_v != starting.func_177982_a(i, 0, j).func_177952_p()) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockPos vecToBlockPos(Vec3d vec) {
        return new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean movingUp(Entity entity) {
        return entity.field_70163_u > entity.field_70167_r;
    }

    public static boolean movingDown(Entity entity) {
        return entity.field_70163_u < entity.field_70167_r;
    }

    public static boolean isEntityRotating(EntityLivingBase entity) {
        return entity.field_70760_ar != entity.field_70761_aq;
    }

    public static Gender getGenderFromValue(int i) {
        return i == 1 ? Gender.MALE : Gender.FEMALE;
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static boolean isEntityMoving(Entity e) {
        return e.field_70165_t != e.field_70169_q && e.field_70161_v != e.field_70166_s;
    }

    public static String getTraitName(int traitID) {
        switch (traitID) {
            default: {
                return "None";
            }
            case 1: {
                return "Hardy";
            }
            case 2: {
                return "Lonely";
            }
            case 3: {
                return "Brave";
            }
            case 4: {
                return "Adamant";
            }
            case 5: {
                return "Naughty";
            }
            case 6: {
                return "Bold";
            }
            case 7: {
                return "Docile";
            }
            case 8: {
                return "Relaxed";
            }
            case 9: {
                return "Impish";
            }
            case 10: {
                return "Lax";
            }
            case 11: {
                return "Timid";
            }
            case 12: {
                return "Hasty";
            }
            case 13: {
                return "Serious";
            }
            case 14: {
                return "Jolly";
            }
            case 15: {
                return "Naive";
            }
            case 16: {
                return "Modest";
            }
            case 17: {
                return "Mild";
            }
            case 18: {
                return "Quite";
            }
            case 19: {
                return "Bashful";
            }
            case 20: {
                return "Rash";
            }
            case 21: {
                return "Calm";
            }
            case 22: {
                return "Gentle";
            }
            case 23: {
                return "Sassy";
            }
            case 24: {
                return "Careful";
            }
            case 25: 
        }
        return "Quirky";
    }

    public static AnimalData.Traits getTraitFromValue(int traitID) {
        switch (traitID) {
            default: {
                return AnimalData.Traits.NONE;
            }
            case 1: {
                return AnimalData.Traits.HARDY;
            }
            case 2: {
                return AnimalData.Traits.LONELY;
            }
            case 3: {
                return AnimalData.Traits.BRAVE;
            }
            case 4: {
                return AnimalData.Traits.ADAMANT;
            }
            case 5: {
                return AnimalData.Traits.NAUGHTY;
            }
            case 6: {
                return AnimalData.Traits.BOLD;
            }
            case 7: {
                return AnimalData.Traits.DOCILE;
            }
            case 8: {
                return AnimalData.Traits.RELAXED;
            }
            case 9: {
                return AnimalData.Traits.IMPISH;
            }
            case 10: {
                return AnimalData.Traits.LAX;
            }
            case 11: {
                return AnimalData.Traits.TIMID;
            }
            case 12: {
                return AnimalData.Traits.HASTY;
            }
            case 13: {
                return AnimalData.Traits.SERIOUS;
            }
            case 14: {
                return AnimalData.Traits.JOLLY;
            }
            case 15: {
                return AnimalData.Traits.NAIVE;
            }
            case 16: {
                return AnimalData.Traits.MODEST;
            }
            case 17: {
                return AnimalData.Traits.MILD;
            }
            case 18: {
                return AnimalData.Traits.QUIET;
            }
            case 19: {
                return AnimalData.Traits.BASHFUL;
            }
            case 20: {
                return AnimalData.Traits.RASH;
            }
            case 21: {
                return AnimalData.Traits.CALM;
            }
            case 22: {
                return AnimalData.Traits.GENTLE;
            }
            case 23: {
                return AnimalData.Traits.SASSY;
            }
            case 24: {
                return AnimalData.Traits.CAREFUL;
            }
            case 25: 
        }
        return AnimalData.Traits.QUIRKY;
    }

    public static String getNatureString(AnimalData.EnumNature nature) {
        switch (nature) {
            default: {
                return "Undefined";
            }
            case SKITTISH: {
                return "Skittish";
            }
            case PASSIVE: {
                return "Passive";
            }
            case NEUTRAL: {
                return "Neutral";
            }
            case PROTECTIVE: {
                return "Protective";
            }
            case TERRITORIAL: {
                return "Territorial";
            }
            case AGGRESSIVE: {
                return "Aggressive";
            }
            case NONE: 
        }
        return "None";
    }

    @Deprecated
    public static int getAgeTForDays(int days) {
        return days * 23960 - days * 23960 * 2;
    }

    public static boolean blockAtPos(World worldObj, Block block, double posX, double posY, double posZ) {
        Block blockAt = worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c();
        return blockAt == block;
    }

    public static Block getBlockAtPos(World worldObj, double posX, double posY, double posZ) {
        return worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c();
    }

    public static Entity getClosestEntityToEntity(Entity target, Entity e, double distance) {
        return ZAWAUtils.getClosestEntity2(target.getClass(), e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, distance);
    }

    public static Entity getClosestEntityToPlayer(EntityPlayer entityIn, double distance) {
        return ZAWAUtils.getClosestEntity(entityIn.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, distance);
    }

    public static Entity getClosestEntity2(Class search, World world, double x, double y, double z, double distance) {
        double initial = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE.getClass() == search) continue;
            double distSqr = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(distSqr < distance * distance) || initial != -1.0 && !(distSqr < initial)) continue;
            initial = distSqr;
            entityFound = currE;
        }
        return entityFound;
    }

    public static Entity getClosestEntity(World world, double x, double y, double z, double distance) {
        double initial = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE instanceof EntityPlayer) continue;
            double distSqr = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(distSqr < distance * distance) || initial != -1.0 && !(distSqr < initial)) continue;
            initial = distSqr;
            entityFound = currE;
        }
        return entityFound;
    }

    public static <T> Map<T, T> toMap(Set<T> set) {
        ConcurrentHashMap<T, T> map = new ConcurrentHashMap<T, T>();
        for (T st : set) {
            map.put(st, st);
        }
        return map;
    }
}

