/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import org.zawamod.configuration.ZAWASpawnConfig;
import org.zawamod.util.SpawnData;

public class SpawnableAnimal {
    private final Class<? extends EntityLiving> entity;
    private final String name;
    private final int chance;
    private final int min;
    private final int max;
    private final Biome[] biomes;

    public SpawnableAnimal(Class<? extends EntityLiving> entity, String name, int chance, int min, int max, EnumCreatureType type, Biome ... biomes) {
        this.entity = entity;
        this.name = name;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
    }

    public void register() {
        ZAWASpawnConfig.spawns.add(new SpawnData(this.entity, ZAWASpawnConfig.spawnConfig.get(this.name, "Spawn Chance", this.chance).getInt(), ZAWASpawnConfig.spawnConfig.get(this.name, "Min Group", this.min).getInt(), ZAWASpawnConfig.spawnConfig.get(this.name, "Max Group", this.max).getInt(), EnumCreatureType.CREATURE, ZAWASpawnConfig.spawnConfig.getStringList("Biomes", this.name, SpawnData.getBiomeIDS(this.biomes), "")));
    }

    public Class<? extends Entity> getEntity() {
        return this.entity;
    }

    public String getName() {
        return this.name;
    }

    public int getChance() {
        return this.chance;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

