/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.zawamod.ZAWAMain;
import org.zawamod.configuration.ZAWASpawnConfig;

public class SpawnData {
    private Class<? extends EntityLiving> entity;
    private int chance;
    private int min;
    private int max;
    private String[] biomes;
    private EnumCreatureType type;

    public SpawnData(Class<? extends EntityLiving> entity, int chance, int min, int max, EnumCreatureType type, String ... biomes) {
        this.entity = entity;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
        this.type = type;
    }

    public static int[] getDataFromEntity(Entity e) {
        int[] data = new int[3];
        for (SpawnData d : ZAWASpawnConfig.spawns) {
            if (d.getEntity() != e.getClass()) continue;
            data[0] = d.getChance();
            data[1] = d.getMin();
            data[2] = d.getMax();
        }
        return data;
    }

    public Class<? extends EntityLiving> getEntity() {
        return this.entity;
    }

    public int getChance() {
        return this.chance / 2;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public Biome[] getBiomes() {
        Biome[] b = new Biome[this.biomes.length];
        int i = 0;
        for (String s : this.biomes) {
            try {
                b[i] = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(s));
            }
            catch (NullPointerException e) {
                ZAWAMain.logger.error("The specified biome '" + s + "' does not exist : this has to do with the config set by the user. DO NOT CONTACT THE MOD AUTHOR!");
            }
            ++i;
        }
        return SpawnData.removeBiomes(b, SpawnData.getBiomesOfType(BiomeDictionary.Type.WASTELAND));
    }

    public Biome[] getCoreBiomes() {
        Biome[] b = new Biome[this.biomes.length];
        int i = 0;
        for (String s : this.biomes) {
            b[i] = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(s));
            if (b[i] == null) {
                throw new NullPointerException("The specified biome '" + s + "' does not exist : this has to do with the config DO NOT CONTACT THE MOD AUTHOR");
            }
            ++i;
        }
        return b;
    }

    public EnumCreatureType getCreatureType() {
        return this.type;
    }

    public static Biome[] removeBiomes(Biome[] biomes, Biome ... remove) {
        for (Biome b : biomes) {
            for (Biome bR : remove) {
                if (b != bR) continue;
                b = null;
            }
        }
        ArrayList valid = Lists.newArrayList();
        for (Biome b : biomes) {
            if (b == null) continue;
            valid.add(b);
        }
        return valid.toArray(new Biome[valid.size()]);
    }

    public static Biome[] mergeBiomes(Biome[] biomes, Biome ... add) {
        ArrayList valid = Lists.newArrayList();
        for (Biome b : biomes) {
            valid.add(b);
        }
        for (Biome b : add) {
            valid.add(b);
        }
        return valid.toArray(new Biome[valid.size()]);
    }

    public static Biome[] mergeBiomes(Biome[] ... biomes) {
        ArrayList valid = Lists.newArrayList();
        for (Biome[] biome : biomes) {
            for (int i = 0; i < biome.length; ++i) {
                valid.add(biome[i]);
            }
        }
        return valid.toArray(new Biome[valid.size()]);
    }

    public static String[] getBiomeIDS(Biome[] biomes) {
        ArrayList b = Lists.newArrayList();
        for (int i = 0; i < biomes.length; ++i) {
            if (b.contains(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biomes[i]).toString())) continue;
            b.add(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biomes[i]).toString());
        }
        return b.toArray(new String[0]);
    }

    public static Biome[] getBiomesOfType(BiomeDictionary.Type type) {
        ArrayList valid = Lists.newArrayList();
        for (Biome b : Biome.field_185377_q) {
            Set bom = BiomeDictionary.getTypes((Biome)b);
            if (!bom.contains(type)) continue;
            valid.add(b);
        }
        return valid.toArray(new Biome[valid.size()]);
    }
}

