/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.proxy;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.common.entity.npc.EntityNPC;
import org.zawamod.ZAWAMain;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.configuration.ZAWASpawnConfig;
import org.zawamod.configuration.ZAWAWorldConfig;
import org.zawamod.entity.ZAWAEntity;
import org.zawamod.entity.base.ZAWABaseWater;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.water.EntityFishBase;
import org.zawamod.event.ZAWAEventHandler;
import org.zawamod.gui.GuiHandler;
import org.zawamod.init.EnrichmentHandler;
import org.zawamod.init.ZAWACrafting;
import org.zawamod.init.ZAWAItems;
import org.zawamod.init.blocks.te.TileEntityBench;
import org.zawamod.init.blocks.te.TileEntityCampFire;
import org.zawamod.init.blocks.te.TileEntityFeeder;
import org.zawamod.init.blocks.te.TileEntityLightBlock;
import org.zawamod.init.blocks.te.TileEntityPerch;
import org.zawamod.network.ZAWAPacketHandler;
import org.zawamod.util.SpawnData;
import org.zawamod.util.ZAWASounds;
import org.zawamod.world.ZAWAWorldGenerator;

public class CommonProxy {
    public static List<Item> registeredItems;

    @SideOnly(value=Side.CLIENT)
    public List<BookwormModelBase> getPerchedModels() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderLivingZAWA> getPerchRenders() {
        return null;
    }

    public void preInit(FMLPreInitializationEvent event) {
        EnrichmentHandler.initialize();
        ZAWAWorldConfig.init(event);
        ZAWAConfig.init(event);
        ZAWASpawnConfig.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new ZAWAEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new ZAWAEventHandler());
        ZAWAEntity.Register();
        GameRegistry.registerTileEntity(TileEntityFeeder.class, (String)"zawa:te_zawa_feeder");
        GameRegistry.registerTileEntity(TileEntityPerch.class, (String)"zawa:te_zawa_perch");
        GameRegistry.registerTileEntity(TileEntityCampFire.class, (String)"zawa:te_zawa_campfire");
        GameRegistry.registerTileEntity(TileEntityLightBlock.class, (String)"zawa:te_zawa_light_block");
        GameRegistry.registerTileEntity(TileEntityBench.class, (String)"zawa:te_zawa_bench");
    }

    public void init(FMLInitializationEvent event) {
        ZAWAPacketHandler.initPackets();
        OreDictionary.registerOre((String)"egg", (Item)ZAWAItems.ALBATROSS_EGG_ITEM);
        OreDictionary.registerOre((String)"egg", (Item)ZAWAItems.COCKATOO_EGG_ITEM);
        OreDictionary.registerOre((String)"egg", (Item)ZAWAItems.MACAW_EGG);
        OreDictionary.registerOre((String)"egg", (Item)ZAWAItems.TOUCAN_EGG_ITEM);
        OreDictionary.registerOre((String)"ingredientEgg", (Item)ZAWAItems.ALBATROSS_EGG_ITEM);
        OreDictionary.registerOre((String)"ingredientEgg", (Item)ZAWAItems.COCKATOO_EGG_ITEM);
        OreDictionary.registerOre((String)"ingredientEgg", (Item)ZAWAItems.MACAW_EGG);
        OreDictionary.registerOre((String)"ingredientEgg", (Item)ZAWAItems.TOUCAN_EGG_ITEM);
        OreDictionary.registerOre((String)"listAllegg", (Item)ZAWAItems.ALBATROSS_EGG_ITEM);
        OreDictionary.registerOre((String)"listAllegg", (Item)ZAWAItems.COCKATOO_EGG_ITEM);
        OreDictionary.registerOre((String)"listAllegg", (Item)ZAWAItems.MACAW_EGG);
        OreDictionary.registerOre((String)"listAllegg", (Item)ZAWAItems.TOUCAN_EGG_ITEM);
        OreDictionary.registerOre((String)"zawaFur", (Item)ZAWAItems.TIGER_FUR);
        OreDictionary.registerOre((String)"zawaFur", (Item)ZAWAItems.FUR);
        OreDictionary.registerOre((String)"zawaFur", (Item)ZAWAItems.POLAR_BEAR_HIDE);
        OreDictionary.registerOre((String)"zawaFur", (Item)ZAWAItems.AMUR_LEOPARD_HIDE);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.ELEPHANT_LEATHER);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.REPTILE_HIDE);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.RHINO_HIDE);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.GORILLA_HIDE);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.GIRAFFE_HIDE);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.ZEBRA_LEATHER);
        OreDictionary.registerOre((String)"zawaHide", (Item)ZAWAItems.CROCODILE_LEATHER);
        ZAWASounds.registerSounds();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ZAWAMain.instance, (IGuiHandler)new GuiHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ZAWAWorldGenerator(), (int)100);
        if (ZAWAConfig.canSpawn) {
            System.out.println("Loading configured spawns");
            for (SpawnData spawn : ZAWASpawnConfig.spawns) {
                if (spawn.getChance() <= 0 || ZAWABaseWater.class.isAssignableFrom(spawn.getEntity()) || EntityFishBase.class.isAssignableFrom(spawn.getEntity())) continue;
                if (!ZAWAConfig.keeperSpawns) {
                    if (EntityNPC.class.isAssignableFrom(spawn.getEntity())) continue;
                    EntityRegistry.addSpawn(spawn.getEntity(), (int)spawn.getChance(), (int)spawn.getMin(), (int)spawn.getMax(), (EnumCreatureType)spawn.getCreatureType(), (Biome[])spawn.getBiomes());
                    continue;
                }
                EntityRegistry.addSpawn(spawn.getEntity(), (int)spawn.getChance(), (int)spawn.getMin(), (int)spawn.getMax(), (EnumCreatureType)spawn.getCreatureType(), (Biome[])spawn.getBiomes());
            }
        }
        ZAWACrafting.init(event);
    }

    public void postInit(FMLPostInitializationEvent event) {
        registeredItems = new ArrayList<Item>();
        registeredItems.addAll(ForgeRegistries.ITEMS.getValues());
        BreedItems.registerFoodItems();
    }

    public void registerRenders() {
    }

    public float getPartialTicks() {
        return 0.0f;
    }

    public static enum GUI {
        ANIMAL_STATS,
        TRACKER,
        DATA,
        INFO,
        CARE_GUIDE,
        EXPLORATION;

        public final int id = GUI.getNextId();
        static int count;

        private static int getNextId() {
            return count++;
        }

        static {
            count = 0;
        }
    }
}

