/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.init.blocks.te;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaDoubleChestItemHandler;
import org.zawamod.init.blocks.BlockFeeder;

public class TileEntityFeeder
extends TileEntityChest {
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public boolean field_145984_a;
    public TileEntityFeeder field_145992_i;
    public TileEntityFeeder field_145990_j;
    public TileEntityFeeder field_145991_k;
    public TileEntityFeeder field_145988_l;
    public float field_145989_m;
    public float field_145986_n;
    public int field_145987_o;
    private int ticksSinceSync;
    public VanillaDoubleChestItemHandler doubleChestHandler;

    public boolean getMajority() {
        int meat = 0;
        int veg = 0;
        int none = 0;
        for (int i = 0; i < 27; ++i) {
            if (this.func_70301_a(i) != null) {
                if (this.func_70301_a(i).func_77973_b() instanceof ItemFood || this.func_70301_a(i).func_77973_b() instanceof ItemSeeds) {
                    int n = this.func_70301_a(i).func_77973_b() instanceof ItemFood ? (((ItemFood)this.func_70301_a(i).func_77973_b()).func_77845_h() ? meat++ : veg++) : veg++;
                    continue;
                }
                ++none;
                continue;
            }
            ++none;
        }
        return meat > veg;
    }

    public int getCount(int id) {
        int meat = 0;
        int veg = 0;
        int none = 0;
        for (int i = 0; i < 27; ++i) {
            if (this.func_70301_a(i) != null) {
                if (this.func_70301_a(i).func_77973_b() instanceof ItemFood || this.func_70301_a(i).func_77973_b() instanceof ItemSeeds) {
                    int n = this.func_70301_a(i).func_77973_b() instanceof ItemFood ? (((ItemFood)this.func_70301_a(i).func_77973_b()).func_77845_h() ? meat++ : veg++) : veg++;
                    continue;
                }
                ++none;
                continue;
            }
            ++none;
        }
        switch (id) {
            case 0: {
                return none;
            }
            case 1: {
                return meat;
            }
            case 2: {
                return veg;
            }
        }
        return -1;
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.chestContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "Animal Feeder";
    }

    public static void registerFixesChest(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityFeeder.class, new String[]{"Items"}));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.chestContents);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.chestContents);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.field_145984_a = false;
        this.doubleChestHandler = null;
    }

    private void setNeighbor(TileEntityFeeder chestTe, EnumFacing side) {
        if (chestTe.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chestTe) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    public void func_145979_i() {
        if (!this.field_145984_a) {
            this.field_145984_a = true;
            this.field_145991_k = this.getAdjacentChest(EnumFacing.WEST);
            this.field_145990_j = this.getAdjacentChest(EnumFacing.EAST);
            this.field_145992_i = this.getAdjacentChest(EnumFacing.NORTH);
            this.field_145988_l = this.getAdjacentChest(EnumFacing.SOUTH);
        }
    }

    @Nullable
    protected TileEntityFeeder getAdjacentChest(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (tileentity = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntityFeeder) {
            TileEntityFeeder tileentitychest = (TileEntityFeeder)tileentity;
            tileentitychest.setNeighbor(this, side.func_176734_d());
            return tileentitychest;
        }
        return null;
    }

    private boolean isChestAt(BlockPos posIn) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(posIn).func_177230_c();
        return block instanceof BlockFeeder;
    }

    public void func_73660_a() {
        this.func_145979_i();
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.field_145987_o != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.field_145987_o = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.field_145987_o;
            }
        }
        this.field_145986_n = this.field_145989_m;
        float f1 = 0.1f;
        if (this.field_145987_o > 0 && this.field_145989_m == 0.0f && this.field_145992_i == null && this.field_145991_k == null) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            if (this.field_145988_l != null) {
                d2 += 0.5;
            }
            if (this.field_145990_j != null) {
                d1 += 0.5;
            }
        }
        if (this.field_145987_o == 0 && this.field_145989_m > 0.0f || this.field_145987_o > 0 && this.field_145989_m < 1.0f) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.field_145850_b.func_175625_s(this.field_174879_c).func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
            this.func_145829_t();
            float f2 = this.field_145989_m;
            this.field_145989_m = this.field_145987_o > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            float f3 = 0.5f;
            if (this.field_145989_m < 0.5f && f2 >= 0.5f && this.field_145992_i == null && this.field_145991_k == null) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                if (this.field_145988_l != null) {
                    d0 += 0.5;
                }
                if (this.field_145990_j != null) {
                    d3 += 0.5;
                }
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.field_145987_o = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145987_o < 0) {
                this.field_145987_o = 0;
            }
            ++this.field_145987_o;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.field_145987_o);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockFeeder) {
            --this.field_145987_o;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.field_145987_o);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.doubleChestHandler == null || this.doubleChestHandler.needsRefresh()) {
                this.doubleChestHandler = VanillaDoubleChestItemHandler.get((TileEntityChest)this);
            }
            if (this.doubleChestHandler != null && this.doubleChestHandler != VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE) {
                return (T)this.doubleChestHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getSingleChestHandler() {
        return (IItemHandler)super.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
        this.func_145979_i();
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

