/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.init.blocks.te;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import org.zawamod.init.blocks.BlockBench;

public class TileEntityBench
extends TileEntity
implements ITickable {
    public boolean adjacentBenchChecked;
    public TileEntityBench adjacentBenchZNeg;
    public TileEntityBench adjacentBenchXPos;
    public TileEntityBench adjacentBenchXNeg;
    public TileEntityBench adjacentBenchZPos;

    public void func_145836_u() {
        super.func_145836_u();
        this.adjacentBenchChecked = false;
    }

    private void setNeighbor(TileEntityBench BenchTe, EnumFacing side) {
        if (BenchTe.func_145837_r()) {
            this.adjacentBenchChecked = false;
        } else if (this.adjacentBenchChecked) {
            switch (side) {
                case NORTH: {
                    if (this.adjacentBenchZNeg == BenchTe) break;
                    this.adjacentBenchChecked = false;
                    break;
                }
                case SOUTH: {
                    if (this.adjacentBenchZPos == BenchTe) break;
                    this.adjacentBenchChecked = false;
                    break;
                }
                case EAST: {
                    if (this.adjacentBenchXPos == BenchTe) break;
                    this.adjacentBenchChecked = false;
                    break;
                }
                case WEST: {
                    if (this.adjacentBenchXNeg == BenchTe) break;
                    this.adjacentBenchChecked = false;
                }
            }
        }
    }

    public void checkForAdjacentBenches() {
        if (!this.adjacentBenchChecked) {
            this.adjacentBenchChecked = true;
            this.adjacentBenchXNeg = this.getAdjacentBench(EnumFacing.WEST);
            this.adjacentBenchXPos = this.getAdjacentBench(EnumFacing.EAST);
            this.adjacentBenchZNeg = this.getAdjacentBench(EnumFacing.NORTH);
            this.adjacentBenchZPos = this.getAdjacentBench(EnumFacing.SOUTH);
        }
    }

    @Nullable
    protected TileEntityBench getAdjacentBench(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isBenchAt(blockpos) && (tileentity = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntityBench) {
            TileEntityBench tileentityBench = (TileEntityBench)tileentity;
            tileentityBench.setNeighbor(this, side.func_176734_d());
            return tileentityBench;
        }
        return null;
    }

    private boolean isBenchAt(BlockPos posIn) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(posIn).func_177230_c();
        return block instanceof BlockBench;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
        this.checkForAdjacentBenches();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_73660_a() {
        this.checkForAdjacentBenches();
    }
}

