/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.init.blocks;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.ZAWAEntity;
import org.zawamod.entity.base.ZAWABaseFlying;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.flying.EntityCockatoo;
import org.zawamod.entity.flying.EntityMacaw;
import org.zawamod.entity.flying.EntityToucan;
import org.zawamod.init.ZAWAItems;
import org.zawamod.init.blocks.ZAWAEnrichmentBlock;
import org.zawamod.init.blocks.te.TileEntityPerch;
import org.zawamod.util.INetHandler;

public class BlockBirdPerch
extends ZAWAEnrichmentBlock
implements INetHandler,
ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockBirdPerch(Material materialIn) {
        super("bird_perch", materialIn);
        this.func_149647_a(ZAWAMain.zawaTabDecor);
        this.field_149758_A = true;
    }

    public boolean func_149716_u() {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPerch();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)1.3f, (double)0.9f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        ItemStack stack = playerIn.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == ZAWAItems.NET) {
            if (stack.func_77978_p() != null) {
                ZAWABaseFlying entity;
                NBTTagCompound nbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("Data");
                String id = stack.func_77978_p().func_74779_i("Entity");
                Entity entity2 = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74779_i("Entity")), (World)worldIn);
                if (entity2 != null && entity2 instanceof ZAWABaseFlying && ZAWAEntity.isZAWAAnimal(entity2.func_70005_c_()) && (entity = (ZAWABaseFlying)entity2).hasValidSit()) {
                    String newName = entity.func_70005_c_().replaceAll(" ", "");
                    newName = newName.replaceAll("'", "");
                    te.getTileData().func_74768_a("Variant", nbt.func_74762_e("Varient"));
                    if (entity instanceof EntityToucan) {
                        te.getTileData().func_74768_a("Type", 0);
                    }
                    if (entity instanceof EntityCockatoo) {
                        te.getTileData().func_74768_a("Type", 1);
                    }
                    if (entity instanceof EntityMacaw) {
                        te.getTileData().func_74768_a("Type", 2);
                    }
                    te.getTileData().func_74778_a("Name", newName);
                    te.getTileData().func_74778_a("Id", id);
                    te.getTileData().func_74782_a("Data", stack.func_77978_p().func_74781_a("Data"));
                    stack.func_77982_d(null);
                    entity.func_70106_y();
                    entity2.func_70106_y();
                    worldIn.func_175704_b(pos, pos);
                    te.func_70296_d();
                }
            }
        } else if (te.getTileData().func_74764_b("Id") && playerIn.func_70093_af()) {
            Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(te.getTileData().func_74779_i("Id")), (World)worldIn);
            e.func_70020_e((NBTTagCompound)te.getTileData().func_74781_a("Data"));
            e.func_70012_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0f, 0.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d(e);
            }
            te.getTileData().func_74768_a("Variant", -1);
            te.getTileData().func_74768_a("Type", -1);
            te.getTileData().func_82580_o("Id");
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        te.getTileData().func_74768_a("Rotation", ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a());
        te.getTileData().func_74768_a("Offset", RANDOM.nextInt(200));
        te.getTileData().func_74768_a("Type", -1);
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te.getTileData().func_74764_b("Id")) {
            Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(te.getTileData().func_74779_i("Id")), (World)world);
            e.func_70020_e((NBTTagCompound)te.getTileData().func_74781_a("Data"));
            e.func_70012_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0f, 0.0f);
            if (!world.field_72995_K) {
                world.func_72838_d(e);
            }
            te.getTileData().func_74768_a("Variant", -1);
            te.getTileData().func_74768_a("Type", -1);
            te.getTileData().func_82580_o("Id");
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    @Override
    public boolean canAnimalUse(ZAWABaseLand animal) {
        return animal instanceof ZAWABaseFlying;
    }

    @Override
    public float enrichmentAmount() {
        return 5.0f;
    }

    @Override
    public float enrichmentSaturation() {
        return 0.7f;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPerch();
    }

    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

