/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.soggymustache.bookworm.common.entity.npc.EntityNPC;
import org.lwjgl.opengl.GL11;
import org.zawamod.configuration.ZAWASpawnConfig;
import org.zawamod.util.SpawnData;

public class GuiExplorationGuide
extends GuiScreen {
    private Minecraft mc = Minecraft.func_71410_x();
    private final int ImageHeight = 201;
    private final int ImageWidth = 318;
    private static final ResourceLocation GUITextures = new ResourceLocation("zawa:textures/gui/exploration_guide.png");
    private int mouseX;
    private int mouseY;
    private GuiScrollingList biomes;
    private List<Biome> bs = ZAWASpawnConfig.biomes;
    private Biome selected;
    private List<Entity> entities = new ArrayList<Entity>();

    public GuiExplorationGuide(EntityPlayer player) {
        this.selected = player.field_70170_p.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int offLeft = (this.field_146294_l - 318) / 2;
        boolean offTop = false;
        this.biomes = new GuiScrollingList(this.mc, 130, this.field_146295_m, 3, this.field_146295_m - 2, 2, 14){

            protected boolean isSelected(int index) {
                return ((Biome)GuiExplorationGuide.this.bs.get(index)).equals(GuiExplorationGuide.this.selected);
            }

            protected int getSize() {
                return GuiExplorationGuide.this.bs.size();
            }

            protected void elementClicked(int index, boolean doubleClick) {
                GuiExplorationGuide.this.selected = (Biome)GuiExplorationGuide.this.bs.get(index);
                GuiExplorationGuide.this.entities = new ArrayList();
                for (SpawnData sp : ZAWASpawnConfig.spawns) {
                    if (!Arrays.asList(sp.getBiomes()).contains(GuiExplorationGuide.this.selected)) continue;
                    GuiExplorationGuide.this.entities.add(EntityList.func_75616_a((int)EntityList.getID(sp.getEntity()), (World)((GuiExplorationGuide)GuiExplorationGuide.this).mc.field_71441_e));
                }
            }

            protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
                if (this.isSelected(slotIdx)) {
                    GuiExplorationGuide.this.field_146289_q.func_78276_b(((Biome)GuiExplorationGuide.this.bs.get(slotIdx)).func_185359_l(), this.screenWidth / 2 - ((Biome)GuiExplorationGuide.this.bs.get(slotIdx)).func_185359_l().length() * 2, slotTop + 1, 0xFFFF00);
                } else {
                    GuiExplorationGuide.this.field_146289_q.func_78276_b(((Biome)GuiExplorationGuide.this.bs.get(slotIdx)).func_185359_l(), this.screenWidth / 2 - ((Biome)GuiExplorationGuide.this.bs.get(slotIdx)).func_185359_l().length() * 2, slotTop + 1, 0xFFFFFF);
                }
            }

            protected void drawBackground() {
            }
        };
        this.entities = new ArrayList<Entity>();
        for (SpawnData sp : ZAWASpawnConfig.spawns) {
            ArrayList<Biome> biomes;
            if (sp.getEntity().isAssignableFrom(EntityNPC.class) || !(biomes = new ArrayList<Biome>(Arrays.asList(sp.getBiomes()))).contains(this.selected)) continue;
            this.entities.add(EntityList.func_75616_a((int)EntityList.getID(sp.getEntity()), (World)this.mc.field_71441_e));
        }
    }

    public void func_73876_c() {
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.biomes.handleMouseInput(this.mouseX, this.mouseY);
    }

    public void func_73863_a(int parWidth, int parHeight, float particle) {
        GlStateManager.func_179094_E();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mouseX = parWidth;
        this.mouseY = parHeight;
        GlStateManager.func_179142_g();
        this.mc.func_110434_K().func_110577_a(GUITextures);
        int offLeft = (int)((float)(this.field_146294_l - 318) / 2.0f) + 43;
        int offTop = 25;
        int topOffset = 20;
        GuiExplorationGuide.func_146110_a((int)30, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (float)this.field_146294_l, (float)this.field_146295_m);
        this.field_146289_q.func_78276_b("Exploration Guide", offLeft + 35, 16 + topOffset, 0);
        int ie = (this.field_146294_l - this.ImageWidth) / 2;
        int je = (this.field_146295_m - this.ImageHeight) / 2 + 30;
        int pos = 0;
        int posY = 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        int eOffX = -165;
        int eOffY = 70;
        for (Entity e : this.entities) {
            GuiExplorationGuide.drawEntityOnScreen(offLeft + 210 + 40 * pos + eOffX, offTop + 10 + posY + eOffY, 15, 131.0f, 0.0f, (EntityLivingBase)e);
            if (++pos <= 7) continue;
            pos = 0;
            posY += 40;
        }
        pos = 0;
        posY = 0;
        boolean showing = false;
        for (Entity e : this.entities) {
            for (int i = -20; i < 20; ++i) {
                for (int j = -20; j < 20; ++j) {
                    if (this.mouseX == offLeft + 210 + 40 * pos + eOffX + j && this.mouseY == offTop + 10 + posY + i + eOffY && !showing) {
                        showing = true;
                        int[] data = SpawnData.getDataFromEntity(e);
                        this.func_146279_a(e.func_70005_c_() + " (" + data[0] + "/" + data[1] + "/" + data[2] + ")", this.mouseX, this.mouseY);
                        continue;
                    }
                    showing = false;
                }
            }
            if (++pos <= 7) continue;
            pos = 0;
            posY += 40;
        }
        GlStateManager.func_179121_F();
        if (this.selected != null) {
            this.field_146289_q.func_78276_b("Biome: ", offLeft + 35, 25 + topOffset, 0);
            this.field_146289_q.func_78276_b(this.selected.func_185359_l(), offLeft + 65, 25 + topOffset, 4301764);
            this.field_146289_q.func_78276_b("Animals (Chance/Min/Max):", offLeft + 35, 35 + topOffset, 0);
        }
        super.func_73863_a(parWidth, parHeight, particle);
        this.biomes.drawScreen(parWidth, parHeight, particle);
        GlStateManager.func_179121_F();
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 || keyCode == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    protected void func_146273_a(int parMouseX, int parMouseY, int parLastButtonClicked, long parTimeSinceMouseClick) {
    }

    protected void func_146284_a(GuiButton button) {
    }

    public void func_146281_b() {
        this.selected = null;
        this.entities = null;
    }

    public boolean func_73868_f() {
        return false;
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

