/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.vehicle;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.init.ZAWAItems;

public class ZAWABaseVehicle
extends EntityLiving {
    protected static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(ZAWABaseVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> NAME = EntityDataManager.func_187226_a(ZAWABaseVehicle.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Boolean> ANIMAL = EntityDataManager.func_187226_a(ZAWABaseVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> DRIVE = EntityDataManager.func_187226_a(ZAWABaseVehicle.class, (DataSerializer)DataSerializers.field_187193_c);

    public ZAWABaseVehicle(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.6f, 2.3f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(NAME, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(ANIMAL, (Object)false);
        this.field_70180_af.func_187214_a(DRIVE, (Object)Float.valueOf(0.0f));
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean hasAccessableInventory() {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.ATV, 1);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        compound.func_74768_a("Varient", this.getHeldVariant());
        compound.func_74778_a("Name", this.getHeldName());
        compound.func_74757_a("HasAnimal", this.getHolding());
        compound.func_74776_a("DrivingDirection", this.getDrivingDirection());
        return super.func_189511_e(compound);
    }

    public float getDrivingDirection() {
        return ((Float)this.field_70180_af.func_187225_a(DRIVE)).floatValue();
    }

    public boolean getHolding() {
        return (Boolean)this.field_70180_af.func_187225_a(ANIMAL);
    }

    public String getHeldName() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public int getHeldVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.setHeldVariant(compound.func_74762_e("Varient"));
        this.setHeldName(compound.func_74779_i("Name"));
        this.setHolding(compound.func_74767_n("HasAnimal"));
        this.setDrivingDirection(compound.func_74760_g("DrivingDirection"));
    }

    public void setDrivingDirection(float f) {
        this.field_70180_af.func_187227_b(DRIVE, (Object)Float.valueOf(f));
    }

    public void setHolding(Boolean bool) {
        this.field_70180_af.func_187227_b(ANIMAL, (Object)bool);
    }

    public void setHeldName(String string) {
        this.field_70180_af.func_187227_b(NAME, (Object)string);
    }

    public void setHeldVariant(int integer) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)integer);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.20000000029802323);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(250.0);
    }

    public double func_70042_X() {
        return 0.7;
    }

    public SoundEvent getStartupSound() {
        return null;
    }

    public SoundEvent getIdleSound() {
        return null;
    }

    public SoundEvent getDriveSound() {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (this.canHoldAnimals()) {
            if (stack.func_77973_b() == ZAWAItems.NET && !this.getHolding()) {
                if (stack.func_77978_p() != null) {
                    try {
                        Entity entity2 = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74779_i("Entity")), (World)this.field_70170_p);
                        entity2.func_70020_e((NBTTagCompound)stack.func_77978_p().func_74781_a("Data"));
                        if (entity2 instanceof ZAWABaseLand && !((ZAWABaseLand)entity2).isTransportable()) {
                            if (player.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This animal cannot be transported"));
                            }
                            return false;
                        }
                        entity2.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d(entity2);
                            entity2.func_184220_m((Entity)this);
                        }
                        this.setHolding(true);
                        stack.func_77982_d(null);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    catch (Exception es) {
                        System.err.println("Entity cannot be created!");
                    }
                    stack.func_77982_d(null);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                } else if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This net has no entity use 'attack' key to capture an animal"));
                }
            } else if (player.func_70093_af() && this.func_184179_bs() == null) {
                if (this.getHolding()) {
                    this.func_184226_ay();
                    this.setHolding(false);
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_145779_a(this.shiftDrop().func_77973_b(), 1);
                }
                this.func_70106_y();
                return true;
            }
        } else if (player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a(this.shiftDrop().func_77973_b(), 1);
            }
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.func_184219_q((Entity)player) && !player.func_70093_af() && stack != null && stack.func_77973_b() != ZAWAItems.NET) {
            this.func_184185_a(this.getStartupSound(), 1.0f, 1.0f);
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    public float setSpeed() {
        return 0.03f;
    }

    public float setReverseSpeed() {
        return -0.2f;
    }

    public float setTurnSpeed() {
        return 5.04f;
    }

    public float setWaterSpeed() {
        return 0.1f;
    }

    public float setWaterReverseSpeed() {
        return -0.05f;
    }

    public ItemStack shiftDrop() {
        return new ItemStack(ZAWAItems.ATV, 1);
    }

    public boolean canHoldAnimals() {
        return false;
    }

    public float setClimbHeight() {
        return 1.0f;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean isAIEnabled() {
        return false;
    }

    protected void fall(float f) {
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184179_bs() != passenger) {
            float calcX = MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180)));
            float calcZ = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            passenger.func_70107_b(this.field_70165_t - (double)calcX - (double)(calcX * 0.9f), this.field_70163_u + (double)0.8f, this.field_70161_v - (double)calcZ - (double)(calcZ * 0.9f));
        }
        if (this.func_184179_bs() != passenger) {
            return;
        }
        if (!(passenger instanceof EntityPlayer)) {
            return;
        }
        super.func_184232_k(passenger);
    }

    public boolean func_82171_bF() {
        boolean flag = false;
        for (Entity e : this.func_184188_bt()) {
            if (!(e instanceof EntityPlayer)) continue;
            flag = true;
        }
        return flag && this.func_184179_bs() instanceof EntityPlayer;
    }

    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.func_184179_bs() instanceof EntityPlayer) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70177_z -= ((EntityPlayer)this.func_184179_bs()).field_70702_br * this.setTurnSpeed();
            this.field_70126_B = this.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            float kachow = entitylivingbase.field_70702_br * 0.5f;
            p_191986_3_ = entitylivingbase.field_191988_bg * this.setSpeed();
            if (kachow != 0.0f) {
                p_191986_3_ = this.setSpeed() * (float)(p_191986_3_ >= 0.0f ? 1 : -1);
            }
            if (p_191986_3_ <= 0.0f) {
                p_191986_3_ *= 0.25f;
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            boolean flag = false;
            for (Entity e : this.func_184188_bt()) {
                if (e instanceof EntityPlayer) continue;
                flag = true;
            }
            if (!flag) {
                this.field_70747_aH = 0.02f;
                super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        List list = this.func_184188_bt();
        if (!list.isEmpty()) {
            for (Entity e : list) {
                if (!(e instanceof EntityPlayer)) continue;
                return false;
            }
        }
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        if (!list.isEmpty()) {
            for (Entity e : list) {
                if (!(e instanceof EntityPlayer)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !((EntityPlayer)source.func_76346_g()).func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a(this.shiftDrop().func_77973_b(), 1);
            }
            this.func_70106_y();
        }
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }
}

