/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.painting;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.init.ZAWAItems;

public class EntityZooPainting
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public EnumArt art;

    public EntityZooPainting(World worldIn) {
        super(worldIn);
    }

    public EntityZooPainting(World worldIn, BlockPos pos, EnumFacing side) {
        super(worldIn, pos);
        ArrayList arraylist = Lists.newArrayList();
        EnumArt[] aenumart = EnumArt.values();
        int i = aenumart.length;
        for (int j = 0; j < i; ++j) {
            EnumArt enumart;
            this.art = enumart = aenumart[j];
            this.func_174859_a(side);
            if (!this.func_70518_d()) continue;
            arraylist.add(enumart);
        }
        if (!arraylist.isEmpty()) {
            this.art = (EnumArt)((Object)arraylist.get(this.field_70146_Z.nextInt(arraylist.size())));
        }
        this.func_174859_a(side);
    }

    public EntityZooPainting(World worldIn, BlockPos pos, EnumFacing side, EnumArt art) {
        this(worldIn, pos, side);
        this.art = art;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.ZOO_PAINTING, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityZooPainting(World worldIn, BlockPos pos, EnumFacing side, String name) {
        this(worldIn, pos, side);
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(name)) continue;
            this.art = enumart;
            break;
        }
        this.func_174859_a(side);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Motive", this.art.title);
        super.func_70014_b(tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        String s = tagCompund.func_74779_i("Motive");
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(s)) continue;
            this.art = enumart;
        }
        if (this.art == null) {
            this.art = EnumArt.OKAPI;
        }
        super.func_70037_a(tagCompund);
    }

    public int func_82329_d() {
        return this.art.sizeX;
    }

    public int func_82330_g() {
        return this.art.sizeY;
    }

    public void func_110128_b(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityplayer.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.func_70099_a(new ItemStack(ZAWAItems.ZOO_PAINTING), 0.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        BlockPos blockpos = new BlockPos(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        BlockPos blockpos1 = this.field_174861_a.func_177971_a((Vec3i)blockpos);
        this.func_70107_b(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.art.ordinal());
        buffer.writeInt(this.field_174861_a.func_177958_n());
        buffer.writeInt(this.field_174861_a.func_177956_o());
        buffer.writeInt(this.field_174861_a.func_177952_p());
        buffer.writeByte(this.func_174811_aO().func_176745_a());
    }

    public void readSpawnData(ByteBuf buffer) {
        BlockPos pos;
        EnumArt[] aenumart = EnumArt.values();
        this.art = aenumart[buffer.readInt()];
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.field_174861_a = pos = new BlockPos(x, y, z);
        this.func_174859_a(EnumFacing.func_82600_a((int)buffer.readByte()));
    }

    public void func_184523_o() {
    }

    public static enum EnumArt {
        OKAPI("Okapi", 16, 16, 16, 0),
        LION("AfricanLion", 16, 16, 32, 0),
        LEOPARD("AmurLeopard", 16, 16, 48, 0),
        TIGER("BengalTiger", 16, 16, 64, 0),
        RHINO("BlackRhino", 16, 16, 80, 0),
        MONKEY("SpiderMonkey", 16, 16, 96, 0),
        DOLPHIN("BottlenoseDolphin", 16, 16, 112, 0),
        COCKATOO("Cockatoo", 16, 16, 128, 0),
        LIZARD("BandedLizard", 16, 16, 144, 0),
        GAUR("Gaur", 16, 16, 160, 0),
        ANACONDA("Anaconda", 16, 16, 176, 0),
        ZEBRA("GrevyZebra", 16, 16, 0, 16),
        TURTLE("HawksbillSeaTurtle", 16, 16, 16, 16),
        GHARIAL("IndianGharial", 16, 16, 32, 16),
        PANGOLIN("IndianPangolin", 16, 16, 48, 16),
        SALAMANDER("JapaneseSalamander", 16, 16, 64, 16),
        KOALA("Koala", 16, 16, 80, 16),
        MACAW("Macaw", 16, 16, 96, 16),
        HIPPO("NileHippo", 16, 16, 112, 16),
        ORCA("Orca", 16, 16, 128, 16),
        POLARBEAR("PolarBear", 16, 16, 144, 16),
        GIRAFFE("Giraffe", 16, 16, 160, 16),
        TOUCAN("Toucan", 16, 16, 176, 16),
        FROG("TreeFrog", 16, 16, 0, 32),
        GORILLA("Gorilla", 16, 16, 16, 32),
        WALRUS("PacificWalrus", 16, 16, 32, 32),
        ELEPHANT("AsianElephant", 16, 16, 48, 32),
        CONDOR("AndeanCondor", 16, 16, 64, 32),
        KANGAROO("Kangaroo", 16, 16, 80, 32),
        FEED("FeedTrader", 16, 16, 96, 32),
        ANIMAL("AnimalTrader", 16, 16, 112, 32),
        CLOWN("ClownFish", 16, 16, 128, 32),
        FISH("Fish", 16, 16, 144, 32),
        MEERKAT("Meerkat", 16, 16, 160, 32),
        PUFFER("Pufferfish", 16, 16, 176, 32),
        PANDA("RedPanda", 16, 16, 0, 48),
        SALMON("SockeyeSalmon", 16, 16, 16, 48),
        ZOOKEEP("ZooKeeper", 16, 16, 32, 48),
        ALBATROSS("Albatross", 16, 16, 48, 48);

        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private EnumArt(String name, int par1, int par2, int par3, int par4) {
            this.title = name;
            this.sizeX = par1;
            this.sizeY = par2;
            this.offsetX = par3;
            this.offsetY = par4;
        }
    }
}

