/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;

public class EntityReticulatedGiraffe
extends ZAWABaseLand {
    protected static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityReticulatedGiraffe.class, (DataSerializer)DataSerializers.field_187198_h);
    private int blocksToGround;
    private int blocksToGroundBack;

    public EntityReticulatedGiraffe(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 4.2f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.23));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.canBeControlled = true;
        this.yOffset = -0.7f;
        this.shinyData = new float[3];
        this.shinyData[0] = 0.9f;
        this.shinyData[1] = 0.5f;
        this.shinyData[2] = 0.5f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f + 0.4f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.RETICULATED_GIRAFFE_EGG, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(52.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack((Block)Blocks.field_150362_t), "Eats leaves off trees"));
        return new DataItem(s);
    }

    @Override
    public boolean isTransportable() {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityReticulatedGiraffe(this.field_70170_p);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BUSH_MEAT_RAW), new ItemStack(ZAWAItems.BUSH_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.GIRAFFE_HIDE), -1, 1, 3)};
        return drops;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.LeafEaterItems(stack);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151141_av && this.getIsZooAnimal() && !this.func_70631_g_()) {
            this.setHasSaddle(true);
        }
        if (this.getIsZooAnimal() && this.getHasSaddle() && this.func_184188_bt().isEmpty() && this.isOwner(player) && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        Material m;
        int i;
        for (i = 3; i > 0; --i) {
            m = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))), this.field_70163_u - (double)i, this.field_70161_v - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))))).func_185904_a();
            if (m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151582_l) {
                this.blocksToGround = i;
                break;
            }
            this.blocksToGround = 0;
        }
        for (i = 3; i > 0; --i) {
            m = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 2.5f), this.field_70163_u - (double)i, this.field_70161_v - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 2.5f))).func_185904_a();
            if (m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151582_l) {
                this.blocksToGroundBack = i;
                break;
            }
            this.blocksToGroundBack = 0;
        }
        if (this.isHungry() && this.func_184188_bt().isEmpty()) {
            BlockPos pos = new BlockPos((Entity)this);
            int dista = 6;
            block2: for (int i2 = -dista; i2 < dista; ++i2) {
                for (int j = -dista; j < dista; ++j) {
                    for (int k = -dista; k < dista; ++k) {
                        BlockPos b = pos.func_177982_a(i2, j, k);
                        if (!(this.field_70170_p.func_180495_p(b).func_177230_c() instanceof BlockLeaves)) continue;
                        this.func_70661_as().func_75492_a((double)b.func_177958_n(), (double)b.func_177956_o(), (double)b.func_177952_p(), 1.26);
                        if (!this.isHungry()) break block2;
                        if (!this.getIsZooAnimal()) continue;
                        this.setHunger(this.getHunger() + 0.3f);
                        this.setSaturation(this.getSaturation() + 0.01f);
                        this.field_70170_p.func_175698_g(b);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Saddle", this.getHasSaddle());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasSaddle(tagCompund.func_74767_n("Saddle"));
    }

    public boolean getHasSaddle() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setHasSaddle(boolean f) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)f);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.UNGULATE_KIBBLE);
    }

    @Override
    public int setVariants() {
        return 3;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PASSIVE;
    }

    public int getBlocksToGround() {
        return BookwormUtils.isEntityMoving((Entity)this) ? 0 : this.blocksToGround;
    }

    public int getBlocksToGroundBack() {
        return BookwormUtils.isEntityMoving((Entity)this) ? 0 : this.blocksToGroundBack;
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.UNGULATE_VIAL, 1);
    }
}

