/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.IResting;
import org.zawamod.init.ZAWAItems;

public class EntityRedPanda
extends ZAWABaseLand
implements IResting {
    public float lyingTimer;
    public float defaultTimer;
    public boolean standing;
    public int standTimer;

    public EntityRedPanda(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.7f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.25));
        this.shinyData = new float[3];
        this.shinyData[0] = 0.514f;
        this.shinyData[1] = 0.502f;
        this.shinyData[2] = 0.91f;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.OmnivoreItems(stack);
    }

    @Override
    public int setVariants() {
        return 3;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.RED_PANDA_EGG, 1);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.2f;
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.BEAR_KIBBLE, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.BEAR_VIAL, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BUSH_MEAT_RAW), new ItemStack(ZAWAItems.BUSH_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.THICK_FUR), -1, 1, 3)};
        return drops;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityRedPanda(this.field_70170_p);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.NEUTRAL;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getLying()) {
            this.lyingTimer += 0.07f;
            this.defaultTimer = 0.0f;
        } else {
            this.lyingTimer = 0.0f;
            this.defaultTimer += 0.07f;
        }
    }

    @Override
    public boolean getLying() {
        return this.stillTicks >= 40;
    }
}

