/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.water.EntitySockeyeSalmon;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityPolarBear
extends ZAWABaseLand {
    private boolean carryingSalmon = false;
    private int salmonTicks = 0;
    private boolean isStanding;
    private int standTime;
    private int standNext = 140;
    public float standTimer;
    private ZAWABaseLand.AIFight AIFight = new ZAWABaseLand.AIFight();
    private EntityAINearestAttackableTarget AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);

    public EntityPolarBear(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.5f);
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.shinyData = new float[3];
        this.shinyData[0] = 0.3f;
        this.shinyData[1] = 0.7f;
        this.shinyData[2] = 0.9f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.2f;
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    @Override
    public int setVariants() {
        return 5;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.POLAR_BEAR_EGG, 1);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.CarnivoreItems(stack);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.BEAR_KIBBLE, 1);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.BEAR_VIAL, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.POLARBEAR_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.POLARBEAR_HURT;
    }

    @SideOnly(value=Side.CLIENT)
    public void playEatEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (int i = 0; i < 3; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 0.7f), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 0.7f), d0, d1, d2, this.particle);
        }
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.CARNIVORE_MEAT_RAW), new ItemStack(ZAWAItems.CARNIVORE_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.FUR), -1, 1, 3), new EntityDrop(new ItemStack(ZAWAItems.POLAR_BEAR_HIDE), -1, 1, 2)};
        return drops;
    }

    public boolean getStanding() {
        return this.isStanding && !this.carryingSalmon;
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H()) {
            if (this.field_70170_p.func_72890_a((Entity)this, 5.0) != null && !this.isStanding && this.standNext >= 140 && this.field_70173_aa >= 30) {
                this.isStanding = true;
                this.standNext = 0;
                this.standTime = 0;
            }
            if (this.isStanding) {
                ++this.standTime;
                this.standTimer += 0.08f;
            } else {
                this.standTimer = 0.0f;
            }
            if (this.standTime >= 60) {
                this.isStanding = false;
                ++this.standNext;
            }
        }
        if (this.field_70171_ac) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.06);
        } else if (this.isStanding) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        }
        double distance2 = 4.0;
        Entity entityFound2 = null;
        double d4 = -1.0;
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!(currE instanceof EntitySockeyeSalmon) || currE == this) continue;
            double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (!(distance2 < 0.0) && !(d5 < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound2 = currE;
        }
        if (entityFound2 != null && !entityFound2.field_70128_L && !this.carryingSalmon) {
            entityFound2.func_70106_y();
            this.carryingSalmon = true;
        }
        if (this.carryingSalmon) {
            ++this.salmonTicks;
            if (this.salmonTicks >= 40) {
                this.carryingSalmon = false;
                this.playEatEffect();
                this.salmonTicks = 0;
                this.playEatEffect();
                if (this.getIsZooAnimal()) {
                    this.setHunger(this.getHunger() + 3.0f);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean getSalmon() {
        return this.carryingSalmon;
    }

    @Override
    public boolean func_70652_k(Entity e) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.onAttack();
        return e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 12.0f);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityPolarBear(this.field_70170_p);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.AGGRESSIVE;
    }
}

