/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.land.EntityAfricanLion;
import org.zawamod.entity.land.EntityBengalTiger;
import org.zawamod.entity.land.EntityGrevysZebra;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;

public class EntityOkapi
extends ZAWABaseLand {
    protected static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityGrevysZebra.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityOkapi(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.5f);
        this.canBeControlled = true;
        this.shinyData = new float[3];
        this.shinyData[0] = 0.3f;
        this.shinyData[1] = 0.1f;
        this.shinyData[2] = 0.4f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, new ZAWABaseLand.AIAvoidEntity<EntityBengalTiger>(this, EntityBengalTiger.class, 10.0f, 0.23, 0.23));
        this.field_70714_bg.func_75776_a(4, new ZAWABaseLand.AIAvoidEntity<EntityAfricanLion>(this, EntityAfricanLion.class, 10.0f, 0.23, 0.23));
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.UNGULATE_KIBBLE, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.UNGULATE_VIAL, 1);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f + 0.4f;
    }

    @Override
    public int setVariants() {
        return 3;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.OKAPI_EGG, 1);
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack(Items.field_151141_av), "Can be mounted with a saddle"));
        return new DataItem(s);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.HerbivoreItems(stack);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityOkapi(this.field_70170_p);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.LARGE_MEAT_RAW), new ItemStack(ZAWAItems.LARGE_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(Items.field_151116_aA), -1, 1, 2)};
        return drops;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Saddle", this.getHasSaddle());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasSaddle(tagCompund.func_74767_n("Saddle"));
    }

    public boolean getHasSaddle() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setHasSaddle(boolean f) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151141_av && this.getIsZooAnimal()) {
            this.setHasSaddle(true);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if ((stack != null && !this.isFoodItem(stack) || stack == null) && this.getIsZooAnimal() && this.getHasSaddle() && this.func_184187_bx() == null && this.isOwner(player) && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PASSIVE;
    }
}

