/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseCrossover;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusSwimming;

public class EntityNileHippo
extends ZAWABaseCrossover {
    private boolean mouthOpen;
    private int jawTicks;
    private int blockDistance = 0;
    private boolean tempted = false;
    private boolean holdingMelon = false;
    private int melonTicks = 0;

    public EntityNileHippo(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.5f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(5, this.aiWander);
        this.field_70138_W = 1.0f;
        this.shinyData = new float[3];
        this.shinyData[0] = 0.3f;
        this.shinyData[1] = 0.6f;
        this.shinyData[2] = 0.5f;
    }

    @Override
    public int setVariants() {
        return 5;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.GrazzerItems(stack);
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack(Items.field_151127_ba), "Eats melon blocks"));
        s.add(new StatusSwimming());
        return new DataItem(s);
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.NILE_HIPPOPOTAMUS_EGG, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.PACHYDERM_KIBBLE, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.PACHYDERM_VIAL, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(42.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.NILE_HIPPO_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.NILE_HIPPO_HURT;
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[3];
        drops[0] = new EntityDrop(new ItemStack(ZAWAItems.LARGE_MEAT_RAW), new ItemStack(ZAWAItems.LARGE_MEAT_COOKED), -1, 1, 1);
        drops[1] = new EntityDrop(new ItemStack(Items.field_151116_aA), -1, 1, 3);
        drops[1] = new EntityDrop(new ItemStack(ZAWAItems.IVORY_TUSK), -1, 1, 2);
        return drops;
    }

    public boolean getTemped() {
        return this.tempted;
    }

    public boolean getHoldingMelon() {
        return this.holdingMelon;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (this.tempted && stack != null && (stack.func_77973_b() == Items.field_151127_ba || player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150440_ba))) {
            this.holdingMelon = true;
            this.tempted = false;
            stack.func_190918_g(1);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        if (this.holdingMelon) {
            ++this.melonTicks;
        }
        if (this.melonTicks >= 70) {
            this.melonTicks = 0;
            this.holdingMelon = false;
            if (this.getIsZooAnimal()) {
                this.setHunger(this.getHunger() + 1.0f);
            }
            if (this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 2.8f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.1f) - (double)this.field_70130_N, this.field_70163_u + (double)1.4f, this.field_70161_v - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 2.8f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.1f) - (double)this.field_70130_N, d0, d1, d2, new int[]{Item.func_150891_b((Item)Items.field_151127_ba)});
                }
            }
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 4.0) != null && !this.func_70631_g_()) {
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 4.0);
            this.tempted = player.field_71071_by.func_70448_g().func_77973_b() == Items.field_151127_ba || player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150440_ba);
        } else {
            if (!this.holdingMelon) {
                double distance = 6.0;
                Entity entityFound = null;
                double d4 = -1.0;
                for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                    if (!(currE instanceof EntityItem) || ((EntityItem)currE).func_92059_d().func_77973_b() != Items.field_151127_ba && ((EntityItem)currE).func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150440_ba)) continue;
                    double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
                    d4 = d5;
                    entityFound = currE;
                }
                if (entityFound != null && !entityFound.field_70128_L) {
                    this.holdingMelon = true;
                    entityFound.func_70106_y();
                }
            }
            this.tempted = false;
        }
        if (this.field_70171_ac) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(3.06);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        }
        super.func_70636_d();
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70171_ac) {
            this.field_70159_w = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * 0.1f;
            this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.1f;
            if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v)).func_177230_c() != Blocks.field_150350_a) {
                this.field_70181_x = 0.05;
            }
            if (this.field_70146_Z.nextInt(60) == 3) {
                this.field_70177_z += (float)(this.field_70146_Z.nextInt(50) - this.field_70146_Z.nextInt(100));
            }
            if (this.field_70123_F) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
                    this.field_70181_x = 0.5;
                }
                this.field_70159_w = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * 0.3f;
                this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.3f;
            }
            this.field_70761_aq = this.field_70177_z;
        }
        super.func_70071_h_();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity e) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.onAttack();
        return e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 12.0f);
    }

    @Override
    public void func_191986_a(float f, float f1, float f2) {
        if (this.field_70171_ac) {
            this.func_191958_b(f, f1, f2, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            super.func_191986_a(f, f1, f2);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityNileHippo(this.field_70170_p);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.TERRITORIAL;
    }

    public boolean isMouthOpen() {
        return this.mouthOpen;
    }

    public void setMouthOpen(boolean mouthOpen) {
        this.mouthOpen = mouthOpen;
    }

    class AIFight
    extends EntityAIAttackMelee {
        public AIFight() {
            super((EntityCreature)EntityNileHippo.this, 1.4, true);
        }

        protected double func_179512_a(EntityLivingBase evb) {
            return 4.0f + evb.field_70130_N;
        }
    }
}

