/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.status.StatusDigging;

public class EntityMeerkat
extends ZAWABaseLand {
    public int sitNum;
    public int standNum;
    public int digNum;
    private int chanceOO = 150;
    private Random rand = new Random();
    private MeerkatState state;

    public EntityMeerkat(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3f, 0.5f);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.3f;
        this.shinyData[1] = 0.5f;
        this.shinyData[2] = 0.5f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.38);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BUSH_MEAT_RAW), new ItemStack(ZAWAItems.BUSH_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.FUR), -1, 1, 1)};
        return drops;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusDigging());
        return new DataItem(s);
    }

    public void setStatus(MeerkatState state) {
        this.state = state;
    }

    public MeerkatState getStatus() {
        return this.state;
    }

    @Override
    public boolean isTransportable() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H() && this.field_70122_E) {
            if (this.sitNum != 2 || this.standNum != 2 || this.digNum != 2) {
                this.standNum = this.rand.nextInt(this.chanceOO) + 1;
                this.sitNum = this.rand.nextInt(this.chanceOO) + 1;
                this.digNum = this.rand.nextInt(this.chanceOO) + 1;
            } else {
                this.standNum = this.rand.nextInt(this.chanceOO) + 1;
                this.sitNum = this.rand.nextInt(this.chanceOO) + 1;
                this.digNum = this.rand.nextInt(this.chanceOO) + 1;
            }
            if (this.sitNum == 2) {
                if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockGrass || this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockDirt) {
                    this.setStatus(MeerkatState.DIGGING);
                }
            } else if ((this.state == MeerkatState.DIGGING || this.state == MeerkatState.STANDING) && this.standNum == 2) {
                this.setStatus(MeerkatState.NORMAL);
            } else if ((this.state == MeerkatState.DIGGING || this.state == MeerkatState.NORMAL) && this.digNum == 2) {
                this.setStatus(MeerkatState.STANDING);
            }
        } else {
            this.setStatus(MeerkatState.NORMAL);
        }
        if (this.state == MeerkatState.STANDING && BookwormUtils.isEntityMoving((Entity)this)) {
            this.setStatus(MeerkatState.NORMAL);
        }
        if (this.state == MeerkatState.DIGGING) {
            this.func_174808_Z();
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (this.state != MeerkatState.DIGGING) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.InsectivoreItems(stack);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.MEERKAT_EGG, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.FROG_VIAL, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.FROG_KIBBLE, 1);
    }

    @Override
    public int setVariants() {
        return 3;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PASSIVE;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityMeerkat(this.field_70170_p);
    }

    public static enum MeerkatState {
        STANDING,
        DIGGING,
        NORMAL;

    }
}

