/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.Gender;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityLowlandGorilla
extends ZAWABaseLand {
    private ZAWABaseLand.AIFight AIFight = new ZAWABaseLand.AIFight();
    private EntityAINearestAttackableTarget AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private EntityAIPanic AIPanic = new EntityAIPanic((EntityCreature)this, 1.43);
    protected EntityLowlandGorilla target = null;
    private int challengeFightTimeOut = 230;
    private int challengeFightDuration = 0;

    public EntityLowlandGorilla(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.5f);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.2f;
        this.shinyData[1] = 0.2f;
        this.shinyData[2] = 0.4f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_85156_a(this.aiWander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    public boolean sexualDimorphism() {
        return true;
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.GORILLA_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.GORILLA_HURT;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.LeafEaterItems(stack);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.getIsZooAnimal() && this.getGender() == Gender.MALE) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)source.func_76346_g());
            }
        }
        if (!this.getIsZooAnimal() && this.getGender() == Gender.FEMALE) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIPanic);
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity e) {
        this.onAttack();
        return e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 4.0f);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.WESTERN_LOWLAND_GORILLA, 1);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BUSH_MEAT_RAW), new ItemStack(ZAWAItems.BUSH_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.GORILLA_HIDE), -1, 1, 3)};
        return drops;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityLowlandGorilla(this.field_70170_p);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.APE_VIAL, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.APE_KIBBLE, 1);
    }

    @Override
    public int setVariants() {
        return 3;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PROTECTIVE;
    }

    @Override
    public void func_70636_d() {
        if (this.getGender() == Gender.MALE && !this.func_70631_g_()) {
            if (this.challengeFightTimeOut >= 250) {
                double distance2 = 12.0;
                Entity entityFound2 = null;
                if (this.target == null) {
                    double d4 = -1.0;
                    for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                        Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                        if (!(currE instanceof EntityLowlandGorilla) || currE == this || ((EntityLowlandGorilla)currE).getGender() != Gender.MALE) continue;
                        double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        if (!(distance2 < 0.0) && !(d5 < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
                        d4 = d5;
                        entityFound2 = currE;
                    }
                }
                if (entityFound2 != null) {
                    this.target = (EntityLowlandGorilla)entityFound2;
                }
                if (this.target != null && this.target.target != null && this.target.target == this) {
                    ++this.challengeFightDuration;
                    if (this.challengeFightDuration < 70) {
                        this.func_70671_ap().func_75651_a((Entity)this.target, 8.0f, 10.0f);
                        this.target.func_70671_ap().func_75651_a((Entity)this, 8.0f, 10.0f);
                        this.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, (double)1.29f);
                        this.target.func_70661_as().func_75492_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)1.29f);
                        double distance3 = 2.0;
                        Entity entityFound3 = null;
                        double d6 = -1.0;
                        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                            Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                            if (!(currE instanceof EntityLowlandGorilla) || currE == this || ((EntityLowlandGorilla)currE).getGender() != Gender.MALE || ((EntityLowlandGorilla)currE).func_70631_g_()) continue;
                            double d8 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                            if (!(distance3 < 0.0) && !(d8 < distance3 * distance3) || d6 != -1.0 && !(d8 < d6)) continue;
                            d6 = d8;
                            entityFound3 = currE;
                        }
                        if (entityFound3 != null && entityFound3 == this.target) {
                            this.func_70664_aZ();
                            this.field_70181_x *= 0.2999999761581421;
                            this.field_70159_w += (double)(MathHelper.func_76126_a((float)this.field_70177_z) * 0.03f);
                            this.field_70179_y -= (double)(MathHelper.func_76134_b((float)this.field_70177_z) * 0.03f);
                        }
                    }
                }
            }
            if (this.challengeFightDuration >= 70) {
                this.challengeFightDuration = 0;
                this.challengeFightTimeOut = 0;
                this.target.challengeFightTimeOut = 0;
                this.target.challengeFightDuration = 0;
                this.target.target = null;
                this.target = null;
            }
            ++this.challengeFightTimeOut;
        }
        super.func_70636_d();
    }

    public boolean challenging() {
        return this.challengeFightDuration != 0;
    }
}

