/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.egg.EntitySalamanderEgg;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.status.StatusEggLaying;

public class EntityJapaneseGiantSalamander
extends ZAWABaseLand {
    protected static final DataParameter<Byte> EGGS = EntityDataManager.func_187226_a(EntityJapaneseGiantSalamander.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityJapaneseGiantSalamander(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.6f;
        this.shinyData[1] = 0.4f;
        this.shinyData[2] = 0.7f;
    }

    @Override
    public void func_70636_d() {
        if (ZAWAConfig.eggDrops && this.getEggsLayed() < 4 && !this.func_70631_g_() && !this.field_70170_p.field_72995_K && this.field_70171_ac && this.func_70681_au().nextInt(10) == 5) {
            EntitySalamanderEgg egg = new EntitySalamanderEgg(this.field_70170_p);
            egg.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)egg);
            this.setEggsLayed(this.getEggsLayed() + 1);
        }
        super.func_70636_d();
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusEggLaying());
        return new DataItem(s);
    }

    @Override
    public boolean socialInteraction() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EGGS, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Eggs", this.getEggsLayed());
        tagCompound.func_74768_a("Slime", this.getSlime());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setEggsLayed(tagCompund.func_74762_e("Eggs"));
        this.setSlime(tagCompund.func_74762_e("Slime"));
    }

    public int getSlime() {
        return this.getEntityData().func_74762_e("Slime");
    }

    public void setSlime(int i) {
        this.getEntityData().func_74768_a("Slime", i);
    }

    public int getEggsLayed() {
        return ((Byte)this.field_70180_af.func_187225_a(EGGS)).byteValue();
    }

    public void setEggsLayed(int value) {
        this.field_70180_af.func_187227_b(EGGS, (Object)((byte)value));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.getSlime() <= 3) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a(Items.field_151123_aH, 1);
            }
            this.setSlime(this.getSlime() + 1);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public int setVariants() {
        return 4;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.PescatarianItems(stack);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.JAPANESE_GIANT_SALAMANDER_EGG, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.CROCODILE_KIBBLE, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.CROCODILE_VIAL, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(21.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.REPTILE_MEAT_RAW), new ItemStack(ZAWAItems.REPTILE_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.TOXIN_SAC), -1, 1, 1)};
        return drops;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityJapaneseGiantSalamander(this.field_70170_p);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.NEUTRAL;
    }
}

