/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.entity.ai.EntityAIRapidEatGrass;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;

public class EntityGrevysZebra
extends ZAWABaseLand {
    protected static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityGrevysZebra.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIRapidEatGrass entityAIEatGrass;
    private int grassTimer;
    private int lastGrab = 0;

    public EntityGrevysZebra(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.7f);
        this.canBeControlled = true;
        this.yOffset = -0.32f;
        this.shinyData = new float[3];
        this.shinyData[0] = 0.6f;
        this.shinyData[1] = 0.6f;
        this.shinyData[2] = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.entityAIEatGrass = new EntityAIRapidEatGrass(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
    }

    @Override
    protected void func_70619_bc() {
        this.grassTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.grassTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float f2) {
        if (this.grassTimer <= 0) {
            return 0.0f;
        }
        if (this.grassTimer >= 4 && this.grassTimer <= 36) {
            return 1.0f;
        }
        return this.grassTimer < 4 ? ((float)this.grassTimer - f2) / 4.0f : -((float)(this.grassTimer - 40) - f2) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float f2) {
        if (this.grassTimer > 4 && this.grassTimer <= 36) {
            float f = ((float)(this.grassTimer - 4) - f2) / 32.0f;
            return 0.62831855f + 0.24434611f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.grassTimer > 0 ? 1.0471976f : this.field_70125_A * ((float)Math.PI / 180) - 1.0f;
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BUSH_MEAT_RAW), new ItemStack(ZAWAItems.BUSH_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.ZEBRA_LEATHER), -1, 1, 1)};
        return drops;
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.UNGULATE_KIBBLE, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.UNGULATE_VIAL, 1);
    }

    @Override
    public int setVariants() {
        return 4;
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack(Items.field_151141_av), "Can be mounted with a saddle"));
        return new DataItem(s);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.GREVY_ZEBRA_EGG, 1);
    }

    @Override
    public void func_70636_d() {
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K) {
            this.grassTimer = Math.max(0, this.grassTimer - 1);
        }
        if (this.getIsZooAnimal() && this.lastGrab >= 10 && this.field_70170_p.func_72890_a((Entity)this, 1.4) != null && this.isOwner(player = this.field_70170_p.func_72890_a((Entity)this, 1.4)) && this.getHasSaddle() && Math.ceil(player.field_70163_u) == Math.ceil(this.field_70163_u + (double)1.3f) && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
            this.lastGrab = 0;
        }
        if (!this.func_184207_aI()) {
            ++this.lastGrab;
        }
        super.func_70636_d();
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.GrazzerItems(stack);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(34.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityGrevysZebra(this.field_70170_p);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.ZEBRA_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource s) {
        return ZAWASounds.ZEBRA_HURT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Saddle", this.getHasSaddle());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasSaddle(tagCompund.func_74767_n("Saddle"));
    }

    public boolean getHasSaddle() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setHasSaddle(boolean f) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151141_av && this.getIsZooAnimal()) {
            this.setHasSaddle(true);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if (stack.func_77973_b() != ZAWAItems.DATA_BOOK && !this.isFoodItem(stack) && this.getIsZooAnimal() && this.getHasSaddle() && this.func_184187_bx() == null && this.isOwner(player) && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f + 0.4f;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PASSIVE;
    }
}

