/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusClimbing;

public class EntityBlackSpiderMonkey
extends ZAWABaseLand {
    private boolean besideClimbable;

    public EntityBlackSpiderMonkey(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.9f);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.8f;
        this.shinyData[1] = 0.7f;
        this.shinyData[2] = 0.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.43));
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusClimbing());
        return new DataItem(s);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.1f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.SPIDER_MONKEY_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.SPIDER_MONKEY_HURT;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.OmnivoreItems(stack);
    }

    @Override
    public int setVariants() {
        return 4;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70123_F) {
            if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (this.isValidBlock(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0)).func_177230_c())) {
                this.setBesideClimbableBlock(this.field_70123_F);
            }
        }
    }

    public boolean isValidBlock(Block b) {
        return b instanceof BlockLog || b instanceof BlockLeaves || b instanceof BlockPlanks;
    }

    public boolean isBesideClimbableBlock() {
        return this.besideClimbable;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.besideClimbable = climbing;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.BLACK_SPIDER_MONKEY_EGG, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.MONKEY_KIBBLE, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.MONKEY_VIAL, 1);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock() && ZAWAConfig.canClimb;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(17.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.39);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BUSH_MEAT_RAW), new ItemStack(ZAWAItems.BUSH_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.FUR), -1, 1, 3)};
        return drops;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityBlackSpiderMonkey(this.field_70170_p);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.NEUTRAL;
    }
}

