/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.IResting;
import org.zawamod.init.ZAWAItems;

public class EntityBlackRhinoceros
extends ZAWABaseLand
implements IResting {
    private int stillTicks = 0;
    private int lastJump = 0;
    protected EntityBlackRhinoceros target = null;
    private int playFightCooldown = 0;
    private int playFightDuration = 0;

    public EntityBlackRhinoceros(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.8f, 1.9f);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.9f;
        this.shinyData[1] = 0.3f;
        this.shinyData[2] = 0.7f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.BLACK_RHINOCEROS_EGG, 1);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.HerbivoreItems(stack);
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.PACHYDERM_VIAL, 1);
    }

    @Override
    public int setVariants() {
        return 4;
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.PACHYDERM_KIBBLE, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(42.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    public boolean func_70652_k(Entity e) {
        this.onAttack();
        return e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
    }

    @Override
    public void func_70636_d() {
        if (this.func_70631_g_()) {
            EntityBlackRhinoceros rhino;
            double distance2 = 4.0;
            Entity entityFound2 = null;
            double d4 = -1.0;
            for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                if (!(currE instanceof EntityBlackRhinoceros) || currE == this) continue;
                double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (!(distance2 < 0.0) && !(d5 < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
                d4 = d5;
                entityFound2 = currE;
            }
            if (entityFound2 != null && !(rhino = (EntityBlackRhinoceros)entityFound2).func_70631_g_() && rhino.getLying() && this.lastJump >= 40) {
                this.field_70181_x *= 3.899999976158142;
                this.func_70664_aZ();
                for (int i = 0; i < 3; ++i) {
                    this.func_70671_ap().func_75651_a((Entity)rhino, 8.0f, 10.0f);
                }
                float f = this.field_70177_z * ((float)Math.PI / 180);
                this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.3f);
                this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.3f);
                this.lastJump = 0;
            }
            ++this.lastJump;
        } else {
            if (this.playFightCooldown >= 150) {
                double distance2 = 12.0;
                Entity entityFound2 = null;
                if (this.target == null) {
                    double d4 = -1.0;
                    for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                        Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                        if (!(currE instanceof EntityBlackRhinoceros) || currE == this || ((EntityBlackRhinoceros)currE).isTranquilized()) continue;
                        double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        if (!(distance2 < 0.0) && !(d5 < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
                        d4 = d5;
                        entityFound2 = currE;
                    }
                }
                if (entityFound2 != null) {
                    this.target = (EntityBlackRhinoceros)entityFound2;
                }
                if (this.target != null && this.target.target != null && this.target.target == this) {
                    ++this.playFightDuration;
                    if (this.playFightDuration < 70) {
                        this.func_70671_ap().func_75651_a((Entity)this.target, 8.0f, 10.0f);
                        this.target.func_70671_ap().func_75651_a((Entity)this, 8.0f, 10.0f);
                        this.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, (double)1.29f);
                        this.target.func_70661_as().func_75492_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)1.29f);
                        double distance3 = 2.0;
                        Entity entityFound3 = null;
                        double d6 = -1.0;
                        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                            Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                            if (!(currE instanceof EntityBlackRhinoceros) || currE == this) continue;
                            double d8 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                            if (!(distance3 < 0.0) && !(d8 < distance3 * distance3) || d6 != -1.0 && !(d8 < d6)) continue;
                            d6 = d8;
                            entityFound3 = currE;
                        }
                        if (entityFound3 != null && entityFound3 == this.target) {
                            this.func_70664_aZ();
                            this.field_70181_x *= 0.2999999761581421;
                            this.field_70159_w += (double)(MathHelper.func_76126_a((float)this.field_70177_z) * 0.03f);
                            this.field_70179_y -= (double)(MathHelper.func_76134_b((float)this.field_70177_z) * 0.03f);
                        }
                    }
                }
            }
            if (this.playFightDuration >= 70) {
                this.playFightDuration = 0;
                this.target.target = null;
                this.target = null;
                this.playFightCooldown = 0;
            }
            ++this.playFightCooldown;
        }
        super.func_70636_d();
    }

    @Override
    public boolean getLying() {
        return this.stillTicks >= 60 && !this.func_70631_g_();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.LARGE_MEAT_RAW), new ItemStack(ZAWAItems.LARGE_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.RHINO_HORN), -1, 1, 1)};
        drops[1] = new EntityDrop(new ItemStack(ZAWAItems.RHINO_HIDE), -1, 1, 2);
        return drops;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityBlackRhinoceros(this.field_70170_p);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.TERRITORIAL;
    }
}

