/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.EntityBigCat;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.ZAWAUtils;

public class EntityBengalTiger
extends EntityBigCat {
    private boolean canRest = false;
    private int stillCount = 0;
    private float rotation = this.field_70761_aq;

    public EntityBengalTiger(World worldIn) {
        super(worldIn);
        this.field_70138_W = 2.0f;
        this.shinyData = new float[3];
        this.shinyData[0] = 0.9f;
        this.shinyData[1] = 0.6f;
        this.shinyData[2] = 0.4f;
    }

    @Override
    public void onVariantSet() {
        super.onVariantSet();
        if (this.getAnimalType() == 2 || this.getAnimalType() == 5) {
            int a = this.field_70146_Z.nextInt(this.setVariants());
            if (a == 2 || a == 5) {
                a = 1;
            }
            this.setAnimalType(a);
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.5f);
    }

    public int func_82143_as() {
        return 6;
    }

    public boolean canRest() {
        return this.canRest;
    }

    @Override
    public void func_70636_d() {
        this.stillCount = !ZAWAUtils.isEntityRotating((EntityLivingBase)this) ? ++this.stillCount : 0;
        this.canRest = this.stillCount >= 10;
        super.func_70636_d();
    }

    protected float func_175134_bD() {
        return 0.52f;
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.CarnivoreItems(stack);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.TIGER_HURT;
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.TIGER_AMBIENT;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.BENGAL_TIGER_EGG, 1);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.CARNIVORE_MEAT_RAW), new ItemStack(ZAWAItems.CARNIVORE_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.TIGER_FUR), -1, 1, 3)};
        return drops;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityBengalTiger tiger = new EntityBengalTiger(this.field_70170_p);
        if (this.field_70146_Z.nextInt(50) == 4) {
            tiger.setAnimalType(this.field_70146_Z.nextBoolean() ? 5 : 2);
        }
        return tiger;
    }

    @Override
    public int setVariants() {
        return 7;
    }
}

