/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;

public class EntityAsianElephant
extends ZAWABaseLand {
    protected static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityAsianElephant.class, (DataSerializer)DataSerializers.field_187198_h);
    private int blocksToGround;
    private int blocksToGroundBack;

    public EntityAsianElephant(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.2f, 2.9f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.canBeControlled = true;
        this.yOffset = 0.76f;
        this.shinyData = new float[3];
        this.shinyData[0] = 0.1f;
        this.shinyData[1] = 0.6f;
        this.shinyData[2] = 0.5f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.ASIAN_ELEPHANT_EGG, 1);
    }

    @Override
    public boolean displayCuriosity() {
        return true;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.HerbivoreItems(stack);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.PACHYDERM_VIAL, 1);
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StringedItem(new ItemStack(Items.field_151141_av), "Can be mounted with a saddle"));
        return new DataItem(s);
    }

    @Override
    public boolean isTransportable() {
        return false;
    }

    @Override
    public int setVariants() {
        return 5;
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.PACHYDERM_KIBBLE, 1);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151141_av && this.getIsZooAnimal()) {
            this.setHasSaddle(true);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if ((stack != null && !this.isFoodItem(stack) || stack == null) && this.getIsZooAnimal() && this.getHasSaddle() && this.func_184187_bx() == null && this.isOwner(player) && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(55.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    public void func_70636_d() {
        Material m;
        int i;
        for (i = 3; i > 0; --i) {
            m = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))), this.field_70163_u - (double)i, this.field_70161_v - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))))).func_185904_a();
            if (m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151582_l) {
                this.blocksToGround = i;
                break;
            }
            this.blocksToGround = 0;
        }
        for (i = 3; i > 0; --i) {
            m = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - (double)MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180))) * 2.5f), this.field_70163_u - (double)i, this.field_70161_v - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) + (double)(MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 2.5f))).func_185904_a();
            if (m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151582_l) {
                this.blocksToGroundBack = i;
                break;
            }
            this.blocksToGroundBack = 0;
        }
        super.func_70636_d();
    }

    public int getBlocksToGround() {
        return BookwormUtils.isEntityMoving((Entity)this) ? 0 : this.blocksToGround;
    }

    public int getBlocksToGroundBack() {
        return BookwormUtils.isEntityMoving((Entity)this) ? 0 : this.blocksToGroundBack;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.onAttack();
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (!this.func_70631_g_()) {
            entity.field_70181_x += 0.6;
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 7.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.getIsZooAnimal()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.AINearAtt);
        }
        if (source.func_76346_g() != null) {
            double distance2 = 32.0;
            double d4 = -1.0;
            for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i);
                if (!(currE instanceof EntityAsianElephant) || currE == this) continue;
                double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (!(distance2 < 0.0) && !(d5 < distance2 * distance2) || d4 != -1.0 && !(d5 < d4)) continue;
                d4 = d5;
                if (!(source.func_76346_g() instanceof EntityLivingBase)) continue;
                ((EntityAsianElephant)currE).func_70624_b((EntityLivingBase)source.func_76346_g());
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.AELEPHANT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.AELEPHANT_HURT;
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.LARGE_MEAT_RAW), new ItemStack(ZAWAItems.LARGE_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.IVORY_TUSK), -1, 1, 1), new EntityDrop(new ItemStack(ZAWAItems.ELEPHANT_LEATHER), -1, 1, 2)};
        return drops;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Saddle", this.getHasSaddle());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasSaddle(tagCompund.func_74767_n("Saddle"));
    }

    public boolean getHasSaddle() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setHasSaddle(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)saddled);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PROTECTIVE;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityAsianElephant(this.field_70170_p);
    }
}

