/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.flying;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseFlying;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.entity.core.SpeciesData;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityMacaw
extends ZAWABaseFlying
implements IMultiSpeciesEntity {
    public EntityMacaw(World worldIn) {
        super(worldIn);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.3f;
        this.shinyData[1] = 0.5f;
        this.shinyData[2] = 0.1f;
    }

    @Override
    public int setVariants() {
        return 7;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.LeafEaterItems(stack);
    }

    @Override
    public boolean hasValidSit() {
        return true;
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.BIRD_VIAL, 1);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.SKITTISH;
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.MACAW_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.MACAW_HURT;
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BIRD_MEAT), new ItemStack(ZAWAItems.BIRD_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(Items.field_151008_G), -1, 1, 3)};
        return drops;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(11.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.MACAW_SPAWN_EGG, 1);
    }

    @Override
    @Nullable
    public Item getLaidEgg() {
        return ZAWAItems.MACAW_EGG;
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.BIRD_KIBBLE, 1);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151014_N) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a(Items.field_151119_aD, 1);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public List<SpeciesData> speciesData() {
        ArrayList<SpeciesData> lst = new ArrayList<SpeciesData>();
        lst.add(new SpeciesData("Scarlet", 1));
        lst.add(new SpeciesData("Hyacinth", 2));
        lst.add(new SpeciesData("Blue & Gold", 3));
        lst.add(new SpeciesData("Catalina", 4));
        lst.add(new SpeciesData("Spix", 5));
        lst.add(new SpeciesData("Red Shouldered", 6));
        lst.add(new SpeciesData("Military", 7));
        return lst;
    }
}

