/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.flying;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseFlying;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.entity.core.SpeciesData;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityCockatoo
extends ZAWABaseFlying
implements IMultiSpeciesEntity {
    private boolean playing;
    public int playTimer;

    public EntityCockatoo(World worldIn) {
        super(worldIn);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.6f;
        this.shinyData[1] = 0.5f;
        this.shinyData[2] = 0.5f;
    }

    @Override
    @Nullable
    public Item getLaidEgg() {
        return ZAWAItems.COCKATOO_EGG_ITEM;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.LeafEaterItems(stack);
    }

    @Override
    public boolean hasValidSit() {
        return true;
    }

    @Override
    public int setVariants() {
        return 6;
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.BIRD_VIAL, 1);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.COCKATOO_EGG, 1);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.SKITTISH;
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.COCKATOO_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.MACAW_HURT;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.playing) {
            ++this.playTimer;
            if (this.playTimer >= 90) {
                this.playTimer = 0;
                this.playing = false;
            }
        }
        if (this.playing && this.field_70122_E) {
            this.func_70664_aZ();
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70122_E && this.isOwner(player)) {
            this.playing = true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BIRD_MEAT), new ItemStack(ZAWAItems.BIRD_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(Items.field_151008_G), -1, 1, 3)};
        return drops;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(11.0);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.BIRD_KIBBLE, 1);
    }

    @Override
    public List<SpeciesData> speciesData() {
        ArrayList<SpeciesData> lst = new ArrayList<SpeciesData>();
        lst.add(new SpeciesData("Sulphur-Crested", 1));
        lst.add(new SpeciesData("Palm", 2));
        lst.add(new SpeciesData("Carnaby's", 3));
        lst.add(new SpeciesData("Major Mitchell's", 4));
        lst.add(new SpeciesData("Gallah", 5));
        return lst;
    }
}

