/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.flying;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.zawamod.entity.ai.EntityAIAttackEnts;
import org.zawamod.entity.base.ZAWABaseFlying;
import org.zawamod.entity.base.move.EntityExtremeFlyHelperZAWA;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.BreedItems;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.IMultiSpeciesEntity;
import org.zawamod.entity.core.SpeciesData;
import org.zawamod.entity.egg.EntityHawksbillSeaTurtleEgg;
import org.zawamod.entity.water.EntityFish;
import org.zawamod.entity.water.EntityHawksbillSeaTurtle;
import org.zawamod.init.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityAlbatross
extends ZAWABaseFlying
implements IMultiSpeciesEntity {
    public EntityAlbatross(World worldIn) {
        super(worldIn);
        this.field_70765_h = new EntityExtremeFlyHelperZAWA((EntityLiving)this);
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIAttackEnts(this, EntityLiving.class, false, new Predicate(){

            public boolean valid(Entity e) {
                return e instanceof EntityHawksbillSeaTurtle || e instanceof EntityHawksbillSeaTurtleEgg || e instanceof EntityFish;
            }

            public boolean apply(Object o) {
                return this.valid((Entity)o);
            }
        }));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.AIFight);
        this.shinyData = new float[3];
        this.shinyData[0] = 0.3f;
        this.shinyData[1] = 0.5f;
        this.shinyData[2] = 0.8f;
    }

    @Override
    public boolean func_70652_k(Entity e) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
    }

    @Override
    @Nullable
    public Item getLaidEgg() {
        return ZAWAItems.ALBATROSS_EGG_ITEM;
    }

    @Override
    public int setVariants() {
        return 4;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.PescatarianItems(stack);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.BIRD_VIAL, 1);
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PASSIVE;
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.TOUCAN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource s) {
        return ZAWASounds.TOUCAN_HURT;
    }

    @Override
    public EntityDrop[] getDropHandlers() {
        EntityDrop[] drops = new EntityDrop[]{new EntityDrop(new ItemStack(ZAWAItems.BIRD_MEAT), new ItemStack(ZAWAItems.BIRD_MEAT_COOKED), -1, 1, 1), new EntityDrop(new ItemStack(Items.field_151008_G), -1, 1, 3)};
        return drops;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(17.0);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ZAWAItems.ALBATROSS_EGG, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.BIRD_KIBBLE, 1);
    }

    @Override
    public List<SpeciesData> speciesData() {
        ArrayList<SpeciesData> lst = new ArrayList<SpeciesData>();
        lst.add(new SpeciesData("Wandering", 1));
        lst.add(new SpeciesData("Amsterdam", 2));
        lst.add(new SpeciesData("Black-Browed", 3));
        lst.add(new SpeciesData("Black-Footed", 4));
        return lst;
    }
}

