/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.core.IEnrichmentProvider;

public abstract class ZAWAEnrichmentToy
extends EntityLiving
implements IEnrichmentProvider {
    public ZAWAEnrichmentToy(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    public abstract ItemStack setItemDropped();

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.setItemDropped();
    }

    public TextFormatting setColorFormat() {
        return TextFormatting.GREEN;
    }

    public boolean playerHelp() {
        return true;
    }

    public boolean doesPlayerInteract() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (source.func_76364_f() instanceof EntityPlayer && !this.doesPlayerInteract()) {
            if (this.playerHelp()) {
                EntityPlayer player = (EntityPlayer)source.func_76364_f();
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(this.setColorFormat() + "Sneak + Interact : to remove this object"));
                }
                return false;
            }
            if (this.field_70170_p.field_72995_K && source.func_76364_f() != null) {
                double d1 = source.func_76364_f().field_70165_t - this.field_70165_t;
                double d0 = source.func_76364_f().field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.func_70057_ab();
                this.field_70739_aP = (float)(Math.atan2(d0, d1) * 180.0 / Math.PI - (double)this.field_70177_z);
                this.func_70653_a(source.func_76364_f(), amount, d1, d0);
            }
        } else {
            if (source.func_76364_f() instanceof ZAWABaseLand) {
                Entity entity1;
                ZAWABaseLand ent = (ZAWABaseLand)source.func_76364_f();
                if (this.canAnimalUse(ent) && ent.getEnrichment() < ent.getMaxEnrichment()) {
                    ent.setEnrichment(ent.getEnrichment() + this.enrichmentAmount());
                    if (this.field_70170_p.field_72995_K) {
                        ent.playEnrichmentEffect();
                    }
                    this.onEnrichmentUse((ZAWABaseLand)source.func_76364_f());
                }
                if ((entity1 = source.func_76346_g()) != null) {
                    double d1 = entity1.field_70165_t - this.field_70165_t;
                    double d0 = entity1.field_70161_v - this.field_70161_v;
                    while (d1 * d1 + d0 * d0 < 1.0E-4) {
                        d1 = (Math.random() - Math.random()) * 0.01;
                        d0 = (Math.random() - Math.random()) * 0.01;
                    }
                    this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                    this.func_70653_a(entity1, 0.4f, d1, d0);
                }
                if (this.canBeKilled()) {
                    super.func_70097_a(source, amount);
                }
            }
            if (this.field_70170_p.field_72995_K && source.func_76364_f() != null) {
                double d1 = source.func_76364_f().field_70165_t - this.field_70165_t;
                double d0 = source.func_76364_f().field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(source.func_76364_f(), 0.4f, d1, d0);
            }
        }
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a(this.setItemDropped().func_77973_b(), 1);
            }
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void onEnrichmentUse(ZAWABaseLand animal) {
    }

    public void onToyDestoryed() {
    }

    public boolean canBeKilled() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }
}

