/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.status.StatusSwimming;

public abstract class ZAWABaseWater
extends ZAWABaseLand {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(ZAWABaseWater.class, (DataSerializer)DataSerializers.field_187198_h);
    private boolean clientSideTouchedGround;
    protected EntityAIWander wander;
    public boolean ridden;

    public ZAWABaseWater(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.85f, 0.85f);
        this.field_70765_h = new SwimMoveHelper(this);
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusSwimming());
        return new DataItem(s);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, ZAWABaseWater.class, 12.0f, 0.01f));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.ridden && !this.field_70170_p.field_72995_K && this.func_184188_bt().isEmpty() && player.func_184614_ca().func_190926_b()) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (!this.func_70090_H()) {
                if (!(this.field_70181_x > 0.0 && this.clientSideTouchedGround && this.func_174814_R())) {
                    // empty if block
                }
                boolean bl = this.clientSideTouchedGround = this.field_70181_x < 0.0 && this.field_70170_p.func_175677_d(new BlockPos((Entity)this).func_177977_b(), false);
            }
            if (this.isMoving() && this.func_70090_H()) {
                Vec3d vec3d = this.func_70676_i(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3d.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        }
        super.func_70636_d();
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)this.field_70170_p.func_181545_F() && super.func_70601_bi();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isMoving() && !source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
            }
        }
        if (this.wander != null) {
            this.wander.func_179480_f();
        }
        return super.func_70097_a(source, amount);
    }

    public int func_70646_bf() {
        return 180;
    }

    @Override
    public void func_191986_a(float f, float f1, float f2) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(f, f1, f2, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!this.isMoving() && this.func_70638_az() == null) {
                this.field_70181_x += 0.005;
            }
        } else {
            super.func_191986_a(f, f1, f2);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H() && !this.isLandBreather()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public abstract boolean hopToWater();

    public boolean isLandBreather() {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    static class SwimMoveHelper
    extends EntityMoveHelper {
        private final ZAWABaseWater entityGuardian;

        public SwimMoveHelper(ZAWABaseWater Swimmer) {
            super((EntityLiving)Swimmer);
            this.entityGuardian = Swimmer;
        }

        public void func_75641_c() {
            if (!this.entityGuardian.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entityGuardian.field_70165_t;
                double d1 = this.field_75647_c - this.entityGuardian.field_70163_u;
                double d2 = this.field_75644_d - this.entityGuardian.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityGuardian.func_70659_e(this.entityGuardian.func_70689_ay() + (f1 - this.entityGuardian.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                double d6 = Math.sin(this.entityGuardian.field_70177_z * (float)Math.PI / 180.0f);
                this.entityGuardian.field_70159_w += d4 * d5;
                this.entityGuardian.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityGuardian.field_70181_x += (double)this.entityGuardian.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityGuardian.func_70671_ap();
                double d7 = this.entityGuardian.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityGuardian.func_70047_e() + this.entityGuardian.field_70163_u + d1 / d3;
                double d9 = this.entityGuardian.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityGuardian.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityGuardian.setMoving(true);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
                this.entityGuardian.setMoving(false);
            }
        }
    }
}

