/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.util.BookwormRandom;
import org.zawamod.ZAWAMain;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.ai.EntityAIAttackEnts;
import org.zawamod.entity.ai.EntityAIComplexBreeding;
import org.zawamod.entity.ai.EntityAISkilledWander;
import org.zawamod.entity.ai.EntityAIWanderAvoidWaterFlyingZAWA;
import org.zawamod.entity.base.ZAWABaseFlying;
import org.zawamod.entity.base.ZAWABaseWater;
import org.zawamod.entity.base.ZAWAEnrichmentToy;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.entity.core.Gender;
import org.zawamod.entity.core.IBookContainer;
import org.zawamod.entity.core.IEnrichmentProvider;
import org.zawamod.entity.core.IResting;
import org.zawamod.entity.particle.EnrichmentParticle;
import org.zawamod.entity.particle.KibbleParticle;
import org.zawamod.entity.particle.StarvingParticle;
import org.zawamod.init.ZAWABlocks;
import org.zawamod.init.ZAWAItems;
import org.zawamod.init.blocks.te.TileEntityFeeder;
import org.zawamod.init.items.ItemSpawnEggZAWA;
import org.zawamod.proxy.CommonProxy;
import org.zawamod.util.DataItem;
import org.zawamod.util.ZAWAUtils;

public abstract class ZAWABaseLand
extends EntityTameable
implements IBookContainer {
    public static final int FOLLOW = 1;
    public static final int STAY = 2;
    public static final int WANDER = 3;
    protected static final DataParameter<Byte> SIZE_MULTIPLIER = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> GENDER = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> TRAIT = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> parentA = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> parentB = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> HUNGER = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> SATURATION = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> ENRICHMENT = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> ESATURATION = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> HAS_CHILD = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SHINY = EntityDataManager.func_187226_a(ZAWABaseLand.class, (DataSerializer)DataSerializers.field_187198_h);
    protected EntityAIWanderAvoidWaterFlyingZAWA aiWanderFlying;
    protected EntityAIFollowOwnerFlying aiFollowOwnerFlying;
    protected EntityAIFollow aiFollowFlying;
    protected EntityAIFollowOwner aiFollowOwner;
    protected EntityAIBase aiWander;
    protected EntityAIWatchClosest aiWatchClosest;
    protected EntityAILookIdle aiLookIdle;
    protected EntityAIFollowParent aiFollowParent;
    protected EntityAIMoveTowardsTarget aiMoveToTarget;
    protected EntityAIComplexBreeding aiComplexBreeding;
    protected EntityAIHurtByTarget aiTargetFightBack;
    protected AIFight AIFightA;
    protected EntityAINearestAttackableTarget AINearAttA;
    protected AIFight AIFight;
    protected EntityAINearestAttackableTarget AINearAtt;
    protected EntityAIAttackEnts attackBall = new EntityAIAttackEnts(this, EntityLiving.class, false, new Predicate(){

        public boolean shouldAttack(Entity e) {
            return e instanceof IEnrichmentProvider;
        }

        public boolean apply(Object o) {
            return this.shouldAttack((Entity)o);
        }
    });
    public float[] shinyData = null;
    private boolean wantsBlood = true;
    private boolean isSleeping = false;
    protected boolean canBeControlled = false;
    private boolean tranquilized;
    private boolean flag = false;
    private boolean canOnLook = true;
    private boolean blink = false;
    private boolean AISetup;
    protected float yOffset = 0.0f;
    private int socialCount = 0;
    protected int stillTicks = 0;
    private int timeSinceLastLook = 0;
    private byte nextBlink = 0;
    private byte blinkTime = 0;
    private byte blinkSec = 0;
    protected int[] particle = new int[0];
    private BlockPos enrichmentLocation;
    private BookwormRandom rando = new BookwormRandom();

    public ZAWABaseLand(World worldIn) {
        super(worldIn);
        this.blinkSec = (byte)(this.rando.nextByte((byte)23) + 16);
        if (!this.getOriginSpawn()) {
            this.setSizeMultiplier(this.rando.nextByte((byte)9));
            if (!this.func_70631_g_()) {
                this.setParentA(this.rando.nextByte((byte)127));
                this.setParentB(this.rando.nextByte((byte)127));
            }
            if (this.rando.nextByte((byte)20) == 4) {
                this.func_70873_a(-24000);
            }
            if (ZAWAConfig.hasVarients) {
                this.setAnimalType(this.func_70681_au().nextInt(this.setVariants()));
                this.onVariantSet();
            } else {
                this.setAnimalType(1);
            }
            if (this.sexualDimorphism()) {
                this.setGender(ZAWAUtils.getGenderFromValue(this.func_70681_au().nextInt(2)));
            }
            if (this.field_70146_Z.nextInt(273) == 0) {
                this.setShiny(true);
            }
            if (!this.func_70631_g_()) {
                this.setAnimalTrait(ZAWAUtils.getTraitFromValue(this.func_70681_au().nextInt(AnimalData.Traits.values().length - 1)));
            } else {
                this.setAnimalTrait(AnimalData.Traits.NONE);
            }
        }
        this.setOriginSpawn(true);
        if (!(this instanceof ZAWABaseWater)) {
            this.aiFollowOwner = new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f);
        }
        this.aiWander = this.useActive() ? new EntityAISkilledWander(this, 1.0) : new EntityAIWander((EntityCreature)this, 1.0);
        this.aiWatchClosest = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f);
        this.aiLookIdle = new EntityAILookIdle((EntityLiving)this);
        this.aiFollowParent = new EntityAIFollowParent((EntityAnimal)this, 1.1);
        this.aiMoveToTarget = new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f);
        this.aiComplexBreeding = new EntityAIComplexBreeding(this, 1.0);
        this.aiTargetFightBack = new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]);
        this.AIFightA = new AIFight();
        this.AINearAttA = new EntityAINearestAttackableTarget((EntityCreature)this, ZAWAEnrichmentToy.class, true);
        this.AIFight = new AIFight();
        this.AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        if (this instanceof ZAWABaseFlying) {
            this.aiWanderFlying = new EntityAIWanderAvoidWaterFlyingZAWA((EntityCreature)this, 1.0);
            this.aiFollowOwnerFlying = new EntityAIFollowOwnerFlying((EntityTameable)this, 1.0, 5.0f, 1.0f);
            this.aiFollowFlying = new EntityAIFollow((EntityLiving)this, 1.0, 3.0f, 7.0f);
        }
        this.AISetup = true;
        this.func_184651_r();
        this.setControl(-1);
    }

    @Deprecated
    public ZAWABaseLand(World world, float s) {
        this(world);
    }

    public boolean useActive() {
        return false;
    }

    public boolean isHungry() {
        return this.getHunger() < this.getMaxFood() - 0.3f;
    }

    public boolean wantsEnrichment() {
        return this.getEnrichment() < this.getMaxEnrichment() - 0.3f;
    }

    protected void func_184651_r() {
        if (this.AISetup) {
            this.field_70714_bg.func_75776_a(1, this.aiWander);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiWatchClosest);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiLookIdle);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiFollowParent);
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiMoveToTarget);
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiComplexBreeding);
            if (this.setNature() == AnimalData.EnumNature.PROTECTIVE || this.setNature() == AnimalData.EnumNature.TERRITORIAL || this.setNature() == AnimalData.EnumNature.AGGRESSIVE) {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiTargetFightBack);
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)this.field_70130_N * 0.009);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    public EntityLivingBase getOwnerEntity() {
        try {
            UUID uuid = UUID.fromString("" + this.func_184753_b());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public String getOwnerEntityName() {
        try {
            UUID uuid = UUID.fromString("" + this.func_184753_b());
            if (uuid == null || this.field_70170_p.func_152378_a(uuid) == null) {
                return "Unknown Owner";
            }
            return this.field_70170_p.func_152378_a(uuid).func_70005_c_();
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return "Unknown Owner";
        }
    }

    public void func_70071_h_() {
        if (this instanceof IResting) {
            IResting rest = (IResting)((Object)this);
            if (this.func_70660_b(MobEffects.field_76440_q) != null && this.func_70660_b(MobEffects.field_76421_d) != null) {
                this.flag = true;
                this.tranquilized = true;
            } else {
                if (this.flag) {
                    this.stillTicks = 0;
                    this.flag = false;
                    this.tranquilized = false;
                }
                if (this.func_70681_au().nextInt(200) == 4) {
                    this.stillTicks = 0;
                }
                if (ZAWAUtils.isEntityMoving((Entity)this) || this.field_70170_p.func_72890_a((Entity)this, 2.0) != null && !this.getIsZooAnimal()) {
                    this.stillTicks = 0;
                }
                if (!ZAWAUtils.isEntityMoving((Entity)this) && !rest.getLying()) {
                    ++this.stillTicks;
                }
            }
        }
        super.func_70071_h_();
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(field_184756_bw)).orNull();
    }

    public void func_184754_b(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(field_184756_bw, (Object)Optional.fromNullable((Object)uuid));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHINY, (Object)false);
        this.field_70180_af.func_187214_a(HAS_CHILD, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)0);
        this.field_70180_af.func_187214_a(TRAIT, (Object)0);
        this.field_70180_af.func_187214_a(parentA, (Object)0);
        this.field_70180_af.func_187214_a(parentB, (Object)0);
        this.field_70180_af.func_187214_a(HUNGER, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(SATURATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ESATURATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ENRICHMENT, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(SIZE_MULTIPLIER, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Varient", this.getAnimalType());
        tagCompound.func_74778_a("OwnerUUID", this.func_184753_b() == null ? "" : this.func_184753_b().toString());
        tagCompound.func_74780_a("Hunger", (double)this.getHunger());
        tagCompound.func_74780_a("Enrichment", (double)this.getEnrichment());
        tagCompound.func_74768_a("Gender", this.getGender().getValue());
        tagCompound.func_74768_a("Trait", this.getTrait().getID());
        tagCompound.func_74774_a("ParentA", this.getParentA());
        tagCompound.func_74774_a("ParentB", this.getParentB());
        tagCompound.func_74757_a("Spawned", this.getOriginSpawn());
        tagCompound.func_74757_a("Chested", this.isChested());
        tagCompound.func_74774_a("Size", this.getSizeMultiplier());
        tagCompound.func_74768_a("Control", this.getControl());
        tagCompound.func_74780_a("Saturation", (double)this.getSaturation());
        tagCompound.func_74780_a("ESaturation", (double)this.getEnrichmentSaturation());
        tagCompound.func_74757_a("Shiny", this.isShiny());
        tagCompound.func_74782_a("CubData", (NBTBase)this.getHeldCub());
        tagCompound.func_74757_a("Carrying", this.isCarrying());
        tagCompound.func_74768_a("CubCarryTime", this.getCarryTime());
        tagCompound.func_74768_a("CubCarryNext", this.getNextCarryTime());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        String s;
        super.func_70037_a(tagCompound);
        this.setAnimalType(tagCompound.func_74762_e("Varient"));
        if (tagCompound.func_150297_b("OwnerUUID", 8)) {
            s = tagCompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = tagCompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.func_184754_b(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setHunger(tagCompound.func_74760_g("Hunger"));
        this.setEnrichment(tagCompound.func_74760_g("Enrichment"));
        this.setGender(ZAWAUtils.getGenderFromValue(tagCompound.func_74762_e("Gender")));
        this.setAnimalTrait(ZAWAUtils.getTraitFromValue(tagCompound.func_74762_e("Trait")));
        this.setOriginSpawn(tagCompound.func_74767_n("Spawned"));
        this.setChested(tagCompound.func_74767_n("Chested"));
        this.setParentA(tagCompound.func_74771_c("ParentA"));
        this.setParentB(tagCompound.func_74771_c("ParentB"));
        this.setSizeMultiplier(tagCompound.func_74771_c("Size"));
        this.setControl(tagCompound.func_74762_e("Control"));
        this.setSaturation(tagCompound.func_74760_g("Saturation"));
        this.setEnrichmentSaturation(tagCompound.func_74760_g("ESaturation"));
        this.setShiny(tagCompound.func_74767_n("Shiny"));
        this.setHeldCub(tagCompound.func_74775_l("CubData"));
        this.setCarrying(tagCompound.func_74767_n("Carrying"));
        this.setCarryTime(tagCompound.func_74762_e("CubCarryTime"));
        this.setNextCarryTime(tagCompound.func_74762_e("CubCarryNext"));
    }

    public void setControl(int i) {
        this.getEntityData().func_74768_a("Control", i);
    }

    public int getControl() {
        return this.getEntityData().func_74762_e("Control");
    }

    public void setShiny(boolean i) {
        this.func_184212_Q().func_187227_b(SHINY, (Object)i);
    }

    public boolean isShiny() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHINY);
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.getIsZooAnimal() && stack.func_77973_b() == this.setVial().func_77973_b();
    }

    public boolean isOwner(EntityPlayer player) {
        return player.func_110124_au().equals(this.func_184753_b());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ZAWABaseLand anim;
        ItemStack stack = player.func_184586_b(hand);
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemSpawnEggZAWA && this.getPickedResult(null).func_77973_b() == stack.func_77973_b() && (anim = (ZAWABaseLand)this.func_90011_a((EntityAgeable)this)) != null) {
            anim.func_70873_a(-24000);
            anim.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (this.func_70681_au().nextInt(5) != 1) {
                anim.setAnimalTrait(this.getTrait());
            }
            if (this.func_70681_au().nextInt(5) != 1) {
                anim.setAnimalType(this.getAnimalType());
            }
            anim.setParentA(this.getParentA());
            anim.setParentB(this.rando.nextByte((byte)127));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)anim);
            }
            return true;
        }
        if (ZAWABaseLand.getStatItem() != null && stack.func_77973_b() == ZAWABaseLand.getStatItem().func_77973_b()) {
            if (player.field_70170_p.field_72995_K) {
                player.openGui((Object)ZAWAMain.instance, CommonProxy.GUI.DATA.id, player.field_70170_p, (int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v));
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.setTameItem() != null && stack.func_77973_b() == this.setTameItem().func_77973_b() && !this.getIsZooAnimal()) {
            if (this.getTrait().equals((Object)AnimalData.Traits.NAIVE)) {
                if (this.func_70681_au().nextInt(2) == 1) {
                    this.onTame(player);
                    return true;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                return super.func_184645_a(player, hand);
            }
            if (this.getTrait().equals((Object)AnimalData.Traits.LONELY)) {
                if (this.func_70681_au().nextInt(10) == 1) {
                    this.onTame(player);
                    return true;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                return super.func_184645_a(player, hand);
            }
            if (this.getTrait().equals((Object)AnimalData.Traits.CAREFUL)) {
                if (this.func_70681_au().nextInt(12) == 1) {
                    this.onTame(player);
                    return true;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                return super.func_184645_a(player, hand);
            }
            if (this.func_70681_au().nextInt(4) == 1) {
                this.onTame(player);
                return true;
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            return super.func_184645_a(player, hand);
        }
        if (this.isFoodItem(stack) && this.func_70909_n()) {
            this.onFed(player, stack);
            return true;
        }
        if (stack.func_77973_b() instanceof IEnrichmentProvider && this.getIsZooAnimal()) {
            IEnrichmentProvider item = (IEnrichmentProvider)stack.func_77973_b();
            this.onEnrich(item);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void playTameEffect() {
        if (this.field_70170_p.field_72995_K) {
            EnumParticleTypes enumparticletypes = EnumParticleTypes.NOTE;
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playFailEffect() {
        if (this.field_70170_p.field_72995_K) {
            EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playStarvingEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                StarvingParticle newEffect = new StarvingParticle(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)newEffect);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSickEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                StarvingParticle newEffect = new StarvingParticle(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)newEffect);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playEnrichmentEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                EnrichmentParticle newEffect = new EnrichmentParticle(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)newEffect);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playFeedEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                KibbleParticle newEffect = new KibbleParticle(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)newEffect);
            }
        }
    }

    protected final EntityItem getNearbyFood() {
        List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        EntityItem item = null;
        for (EntityItem itm : list) {
            if (!this.isFoodItem(itm.func_92059_d()) || !(this.func_70068_e((Entity)itm) < d0)) continue;
            item = itm;
            d0 = this.func_70068_e((Entity)itm);
        }
        return item;
    }

    public boolean func_70601_bi() {
        if (ZAWAConfig.overworldOnly) {
            if (this.field_71093_bK == 0) {
                return super.func_70601_bi();
            }
            return false;
        }
        return super.func_70601_bi();
    }

    protected final EntityItem getNearbyItemToLook() {
        List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        EntityItem item = null;
        for (EntityItem itm : list) {
            if (this.isFoodItem(itm.func_92059_d()) || !(this.func_70068_e((Entity)itm) < d0)) continue;
            item = itm;
            d0 = this.func_70068_e((Entity)itm);
        }
        return item;
    }

    public ZAWABaseLand getNearbyCub() {
        List list = this.field_70170_p.func_72872_a(ZAWABaseLand.class, this.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        ZAWABaseLand cub = null;
        for (ZAWABaseLand lin : list) {
            if (lin == this || lin.getClass() != this.getClass() || !lin.func_70631_g_() || lin.getParentA() != this.getParentA() || !(this.func_70068_e((Entity)lin) < d0)) continue;
            cub = lin;
            d0 = this.func_70068_e((Entity)lin);
        }
        return cub;
    }

    public boolean canCarryChildren() {
        return false;
    }

    public void func_70636_d() {
        BlockPos b;
        int k;
        int j;
        int i;
        int dista;
        BlockPos pos;
        EntityItem targetFood;
        EntityPlayer player;
        if (!this.getIsZooAnimal()) {
            if (this.wantsBlood && this.field_70146_Z.nextInt(100) == 3) {
                this.wantsBlood = false;
            } else if (!this.wantsBlood && this.field_70146_Z.nextInt(400) == 3) {
                this.wantsBlood = true;
            }
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 4.0) != null && this.isFoodItem((player = this.field_70170_p.func_72890_a((Entity)this, 4.0)).func_184607_cu())) {
            this.func_70671_ap().func_75651_a((Entity)player, 10.0f, (float)this.func_70646_bf());
        }
        if (this.field_70146_Z.nextInt(5) == 3) {
            this.blinkSec = (byte)(this.rando.nextByte((byte)40) + 30);
        }
        if (!this.blink) {
            this.nextBlink = (byte)(this.nextBlink + 1);
        }
        if (this.nextBlink >= this.blinkSec) {
            this.blink = true;
            this.nextBlink = 0;
        }
        if (this.blink) {
            this.blinkTime = (byte)(this.blinkTime + 1);
        }
        if (this.blinkTime >= 3) {
            this.blink = false;
            this.blinkTime = 0;
        }
        if (this.displayCuriosity() && this.func_70631_g_() && this.canOnLook && (targetFood = this.getNearbyItemToLook()) != null) {
            this.func_70671_ap().func_75651_a((Entity)targetFood, 10.0f, (float)this.func_70646_bf());
            this.func_70661_as().func_75497_a((Entity)targetFood, 1.0);
            if (this.func_70068_e((Entity)targetFood) < 9.0) {
                this.canOnLook = false;
            }
        }
        if (this.displayCuriosity()) {
            if (!this.canOnLook) {
                ++this.timeSinceLastLook;
            }
            if (this.timeSinceLastLook >= 170) {
                this.canOnLook = true;
                this.timeSinceLastLook = 0;
            }
        }
        if (this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL) && this.isHungry() && (targetFood = this.getNearbyFood()) != null) {
            this.func_70671_ap().func_75651_a((Entity)targetFood, 10.0f, (float)this.func_70646_bf());
            this.func_70661_as().func_75497_a((Entity)targetFood, 1.0);
            if (this.func_70068_e((Entity)targetFood) < 9.0) {
                this.onFed(null, targetFood.func_92059_d());
                targetFood.func_92059_d().func_190918_g(1);
            }
        }
        if (this.getEnrichment() > this.getMaxEnrichment()) {
            this.setEnrichment(this.getMaxEnrichment());
        }
        if (!this.getIsZooAnimal()) {
            if (this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFight);
                this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
            } else if (this.setNature() == AnimalData.EnumNature.AGGRESSIVE) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
                this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            } else if (this.field_70170_p.func_72890_a((Entity)this, 2.0) != null && (this.setNature() == AnimalData.EnumNature.TERRITORIAL || this.setNature() == AnimalData.EnumNature.PROTECTIVE)) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
                this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            }
        }
        if (ZAWAConfig.deathFromStats && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            if ((double)this.getHunger() <= 3.0 && this.field_70170_p.field_72995_K && this.field_70173_aa % 15 == 0) {
                this.playStarvingEffect();
            }
            if ((double)this.getHunger() <= 0.0 && this.field_70173_aa % 20 == 0) {
                this.func_70665_d(DamageSource.field_76366_f, 0.1f);
            }
            if (this.func_70089_S()) {
                if (this.getSaturation() <= 0.0f) {
                    this.setHunger((float)((double)this.getHunger() - ZAWAConfig.hungerDepreciation));
                    this.setSaturation(0.0f);
                } else {
                    this.setSaturation(this.getSaturation() - 0.0025f);
                }
                if (this.getEnrichmentSaturation() <= 0.0f) {
                    this.setEnrichment((float)((double)this.getEnrichment() - ZAWAConfig.enrichmentDepreciation));
                    this.setEnrichmentSaturation(0.0f);
                } else {
                    this.setEnrichmentSaturation(this.getEnrichmentSaturation() - 0.0045f);
                }
            }
            if ((double)this.getEnrichment() <= 3.0 && this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
                this.playSickEffect();
            }
            if ((double)this.getEnrichment() <= 0.0) {
                this.func_70665_d(ZAWAMain.depression, 0.1f);
            }
        }
        if (this.getHunger() < this.getMaxFood() - 1.0f && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            pos = new BlockPos((Entity)this);
            dista = 6;
            for (i = -dista; i < dista; ++i) {
                for (j = -dista; j < dista; ++j) {
                    block2: for (k = -dista; k < dista; ++k) {
                        b = pos.func_177982_a(i, j, k);
                        if (this.field_70170_p.func_180495_p(b).func_177230_c() != ZAWABlocks.ANIMAL_FEEDER) continue;
                        this.func_70661_as().func_75492_a((double)b.func_177958_n(), (double)b.func_177956_o(), (double)b.func_177952_p(), 1.26);
                        TileEntityFeeder feeder = (TileEntityFeeder)this.field_70170_p.func_175625_s(b);
                        if (feeder == null) continue;
                        for (int spo = 0; spo < feeder.func_70302_i_(); ++spo) {
                            if (feeder.func_70301_a(spo) == ItemStack.field_190927_a || !this.isFoodItem(feeder.func_70301_a(spo))) continue;
                            this.onFed(null, feeder.func_70301_a(spo));
                            feeder.func_70298_a(spo, 1);
                            feeder.func_70296_d();
                            continue block2;
                        }
                    }
                }
            }
        }
        if (this.wantsEnrichment() && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            pos = new BlockPos((Entity)this);
            dista = 6;
            for (i = -dista; i < dista; ++i) {
                for (j = -dista; j < dista; ++j) {
                    for (k = -dista; k < dista; ++k) {
                        b = pos.func_177982_a(i, j, k);
                        if (!(this.field_70170_p.func_180495_p(b).func_177230_c() instanceof IEnrichmentProvider)) continue;
                        this.func_70661_as().func_75492_a((double)b.func_177958_n(), (double)b.func_177956_o(), (double)b.func_177952_p(), 1.26);
                        IEnrichmentProvider block = (IEnrichmentProvider)ZAWAUtils.getBlockAtPos(this.field_70170_p, b.func_177958_n(), b.func_177956_o(), b.func_177952_p());
                        this.onEnrich(block);
                    }
                }
            }
        }
        if (this.socialInteraction()) {
            if (this.socialCount >= 200 && this.getEnrichment() < this.getMaxEnrichment() - 1.0f && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
                double distance = 6.0;
                Entity entityFound = null;
                double d4 = -1.0;
                for (int i2 = 0; i2 < this.field_70170_p.field_72996_f.size(); ++i2) {
                    Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i2);
                    if (currE.getClass() != this.getClass() || currE == this) continue;
                    double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
                    d4 = d5;
                    entityFound = currE;
                }
                if (entityFound != null) {
                    if (this.field_70170_p.field_72995_K) {
                        this.playEnrichmentEffect();
                    }
                    this.setEnrichment(this.getEnrichment() + 0.03f);
                    this.socialCount = 0;
                }
            }
            if (this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
                ++this.socialCount;
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70631_g_() && this instanceof ZAWABaseFlying) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWanderFlying);
        }
        if (this.getIsZooAnimal()) {
            if (this.getControl() == 1) {
                if (!(this instanceof ZAWABaseFlying)) {
                    this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiFollowOwner);
                    this.field_70714_bg.func_75776_a(1, this.aiWander);
                } else {
                    this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiFollowOwnerFlying);
                    this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWanderFlying);
                }
                this.func_70904_g(false);
            } else if (this.getControl() == 3) {
                if (!(this instanceof ZAWABaseFlying)) {
                    this.field_70714_bg.func_75776_a(1, this.aiWander);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwner);
                } else {
                    this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWanderFlying);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwnerFlying);
                }
                this.func_70904_g(false);
            } else if (this.getControl() == 2) {
                if (this instanceof ZAWABaseFlying) {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwnerFlying);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWanderFlying);
                } else {
                    this.field_70714_bg.func_85156_a(this.aiWander);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwner);
                }
                this.func_70904_g(true);
            }
        }
        if (this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            try {
                if (this.getEnrichment() < this.getMaxEnrichment() - 1.0f) {
                    this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.AIFightA);
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.attackBall);
                    this.field_70715_bh.func_75776_a(4, (EntityAIBase)this.AINearAttA);
                } else {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFightA);
                    this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAttA);
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.attackBall);
                }
            }
            catch (Exception e) {
                ZAWAMain.logger.error("Failed to remove tasks, they probably didn't exist");
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.setNature() == AnimalData.EnumNature.PROTECTIVE) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
        }
        return super.func_70097_a(source, amount);
    }

    public EntityDrop[] getDropHandlers() {
        return new EntityDrop[0];
    }

    public void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        super.func_70628_a(wasRecentlyHit, lootingModifier);
        for (EntityDrop drop : this.getDropHandlers()) {
            if (drop == null || !drop.shouldDrop(this.func_70681_au())) continue;
            this.func_145779_a(drop.getItem((Entity)this).func_77973_b(), drop.getRandomAmount(lootingModifier, this.func_70681_au()));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
        return super.func_70652_k(entityIn);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        if (ZAWAConfig.preventIncest) {
            if (this.getParentA() != ((ZAWABaseLand)otherAnimal).getParentA() && this.getParentB() != ((ZAWABaseLand)otherAnimal).getParentB()) {
                if (this.countGenderForBreeding()) {
                    if (this.sexualDimorphism()) {
                        if (((ZAWABaseLand)otherAnimal).getGender() != this.getGender()) {
                            return this.func_70880_s() && otherAnimal.func_70880_s();
                        }
                        return false;
                    }
                    return this.func_70880_s() && otherAnimal.func_70880_s();
                }
                return this.func_70880_s() && otherAnimal.func_70880_s();
            }
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.canBeControlled ? (this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0)) : super.func_184179_bs();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
        if (this.func_184179_bs() != null) {
            this.func_184179_bs().func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + (double)this.yOffset, this.field_70161_v);
        }
    }

    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        if (this.canBeControlled) {
            if (this.func_184179_bs() != null) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
                this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                p_191986_1_ = entitylivingbase.field_70702_br * 0.4f;
                p_191986_3_ = entitylivingbase.field_191988_bg;
                if (p_191986_3_ <= 0.0f) {
                    p_191986_3_ *= 0.25f;
                }
                this.field_70747_aH = 0.02f;
                this.field_70138_W = 1.0f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
                } else if (entitylivingbase instanceof EntityPlayer) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.field_70165_t - this.field_70169_q;
                double d0 = this.field_70161_v - this.field_70166_s;
                float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
            }
        } else {
            super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
        }
    }

    @Override
    public AnimalData.EnumNature setBookNature() {
        return this.setNature();
    }

    @Override
    public AnimalData.Traits setBookTrait() {
        return this.getTrait();
    }

    @Override
    public Gender setBookGender() {
        return this.getGender();
    }

    @Override
    public int setBookVariants() {
        return this.getAnimalType();
    }

    @Override
    public ItemStack tamedBookItem() {
        return this.setTameItem();
    }

    @Override
    public ItemStack breedBookItem() {
        return this.setVial();
    }

    @Override
    public boolean enableSecondPage() {
        return true;
    }

    @Override
    public EntityLivingBase getEntity() {
        return this;
    }

    public boolean isTranquilized() {
        return this.tranquilized;
    }

    public boolean wantsBlood() {
        return this.wantsBlood;
    }

    public boolean sexualDimorphism() {
        return true;
    }

    public void onVariantSet() {
    }

    public float getMaxFood() {
        return 20.0f;
    }

    public void setSizeMultiplier(byte s) {
        this.func_184212_Q().func_187227_b(SIZE_MULTIPLIER, (Object)s);
    }

    public byte getSizeMultiplier() {
        return (Byte)this.func_184212_Q().func_187225_a(SIZE_MULTIPLIER);
    }

    public void setHunger(float currFood) {
        this.func_184212_Q().func_187227_b(HUNGER, (Object)Float.valueOf(currFood));
    }

    public float getHunger() {
        return ((Float)this.func_184212_Q().func_187225_a(HUNGER)).floatValue();
    }

    public float getMaxEnrichment() {
        return 20.0f;
    }

    public void setSaturation(float saturation) {
        this.func_184212_Q().func_187227_b(SATURATION, (Object)Float.valueOf(saturation));
    }

    public float getSaturation() {
        return ((Float)this.func_184212_Q().func_187225_a(SATURATION)).floatValue();
    }

    public void setEnrichmentSaturation(float saturation) {
        this.func_184212_Q().func_187227_b(ESATURATION, (Object)Float.valueOf(saturation));
    }

    public float getEnrichmentSaturation() {
        return ((Float)this.func_184212_Q().func_187225_a(ESATURATION)).floatValue();
    }

    public void setChested(boolean e) {
        this.getEntityData().func_74757_a("Chested", e);
    }

    public boolean isChested() {
        return this.getEntityData().func_74767_n("Chested");
    }

    public void setOriginSpawn(boolean e) {
        this.getEntityData().func_74757_a("Spawn", e);
    }

    public boolean getOriginSpawn() {
        return this.getEntityData().func_74767_n("Spawn");
    }

    public void setEnrichment(float e) {
        this.func_184212_Q().func_187227_b(ENRICHMENT, (Object)Float.valueOf(e));
    }

    public float getEnrichment() {
        return ((Float)this.func_184212_Q().func_187225_a(ENRICHMENT)).floatValue();
    }

    public static ItemStack getStatItem() {
        return new ItemStack(ZAWAItems.DATA_BOOK, 1);
    }

    public abstract ItemStack setVial();

    public abstract ItemStack setTameItem();

    public abstract int setVariants();

    public void onTame(EntityPlayer player) {
        this.func_193101_c(player);
        this.func_184754_b(player.func_110124_au());
        if (this.field_70170_p.field_72995_K) {
            TextComponentString text = new TextComponentString(TextFormatting.GREEN + "Tamed " + this.func_70005_c_() + "!");
            player.func_146105_b((ITextComponent)text, true);
            player.func_145747_a((ITextComponent)text);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70448_g().func_190918_g(1);
        }
        this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFight);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
        this.setHunger(this.getMaxFood());
        this.setEnrichment(this.getMaxEnrichment());
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
    }

    @Nullable
    public void onFed(EntityPlayer player, ItemStack stack) {
        block11: {
            block10: {
                if (stack == null || stack == ItemStack.field_190927_a) {
                    return;
                }
                if (player != null && !player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70448_g().func_190918_g(1);
                }
                if (!this.isHungry()) break block10;
                float nutrition = stack.func_77973_b() instanceof ItemFood ? (float)((ItemFood)stack.func_77973_b()).func_150905_g(stack) : 1.0f;
                float saturation = stack.func_77973_b() instanceof ItemFood ? ((ItemFood)stack.func_77973_b()).func_150906_h(stack) : 0.2f;
                this.setHunger(this.getHunger() + nutrition);
                this.setSaturation(this.getSaturation() + saturation);
                if (this.getHunger() > this.getMaxFood()) {
                    this.setHunger(this.getMaxFood());
                }
                if (this.getSaturation() > 8.0f) {
                    this.setSaturation(8.0f);
                }
                if (!this.field_70170_p.field_72995_K) break block11;
                this.playFeedEffect();
                break block11;
            }
            if (this.isHungry()) {
                if (stack.func_77973_b() instanceof ItemFood) {
                    ItemFood food = (ItemFood)stack.func_77973_b();
                    this.func_70606_j(this.func_110143_aJ() + (float)food.func_150905_g(stack));
                    EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    }
                } else {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                    if (this.field_70170_p.field_72995_K) {
                        this.playTameEffect();
                    }
                    EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    }
                }
            }
        }
    }

    public void onEnrich(IEnrichmentProvider enrichment) {
        if (enrichment == null) {
            return;
        }
        if (!enrichment.canAnimalUse(this)) {
            return;
        }
        if (this.wantsEnrichment()) {
            enrichment.onEnrichmentUse(this);
            this.setEnrichment(this.getEnrichment() + enrichment.enrichmentAmount());
            this.setEnrichmentSaturation(this.getEnrichmentSaturation() + enrichment.enrichmentSaturation());
            if (this.getEnrichment() > this.getMaxEnrichment()) {
                this.setEnrichment(this.getMaxEnrichment());
            }
            if (this.getEnrichmentSaturation() > 8.0f) {
                this.setEnrichmentSaturation(8.0f);
            }
            if (this.field_70170_p.field_72995_K) {
                this.playEnrichmentEffect();
            }
        }
    }

    public int getAnimalType() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setAnimalType(int animalType) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)animalType);
    }

    public byte getParentA() {
        return (Byte)this.field_70180_af.func_187225_a(parentA);
    }

    public void setParentA(byte num) {
        this.field_70180_af.func_187227_b(parentA, (Object)num);
    }

    public byte getParentB() {
        return (Byte)this.field_70180_af.func_187225_a(parentB);
    }

    public void setParentB(byte num) {
        this.field_70180_af.func_187227_b(parentB, (Object)num);
    }

    public AnimalData.Traits getTrait() {
        return ZAWAUtils.getTraitFromValue(((Byte)this.field_70180_af.func_187225_a(TRAIT)).byteValue());
    }

    public void setAnimalTrait(AnimalData.Traits trait) {
        this.field_70180_af.func_187227_b(TRAIT, (Object)((byte)trait.getID()));
    }

    public abstract AnimalData.EnumNature setNature();

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.canSleep() && this.isSleeping();
    }

    public boolean canSleep() {
        return false;
    }

    public boolean flipSleep() {
        return false;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    protected final boolean func_70692_ba() {
        return false;
    }

    public void onAttack() {
    }

    public boolean countGenderForBreeding() {
        return true;
    }

    public boolean isTransportable() {
        return true;
    }

    public boolean socialInteraction() {
        return true;
    }

    public boolean displayCuriosity() {
        return false;
    }

    public boolean getBlinking() {
        return this.blink;
    }

    public DataItem getIconList() {
        return null;
    }

    public boolean affectedBySize() {
        return true;
    }

    public boolean func_82171_bF() {
        return this.canBeControlled ? this.func_184179_bs() instanceof EntityLivingBase : super.func_82171_bF();
    }

    public boolean isFoodItem(ItemStack stack) {
        return false;
    }

    public Gender getGender() {
        return ZAWAUtils.getGenderFromValue(((Byte)this.field_70180_af.func_187225_a(GENDER)).byteValue());
    }

    public void setGender(Gender g) {
        this.field_70180_af.func_187227_b(GENDER, (Object)((byte)g.getValue()));
    }

    public boolean isCarrying() {
        return this.getEntityData().func_74767_n("Carrying");
    }

    public void setCarrying(boolean b) {
        this.getEntityData().func_74757_a("Carrying", b);
    }

    public void setHeldCub(NBTTagCompound tags) {
        this.getEntityData().func_74782_a("CubData", (NBTBase)tags);
    }

    public NBTTagCompound getHeldCub() {
        return this.isCarrying() ? (NBTTagCompound)this.getEntityData().func_74781_a("CubData") : new NBTTagCompound();
    }

    public int getCarryTime() {
        return this.getEntityData().func_74762_e("CubCarryTime");
    }

    public void setCarryTime(int i) {
        this.getEntityData().func_74768_a("CubCarryTime", i);
    }

    public int getNextCarryTime() {
        return this.getEntityData().func_74762_e("CubCarryNext");
    }

    public void setNextCarryTime(int i) {
        this.getEntityData().func_74768_a("CubCarryNext", i);
    }

    public boolean getIsZooAnimal() {
        return this.func_70909_n();
    }

    public class AIFight
    extends EntityAIAttackMelee {
        public AIFight() {
            super((EntityCreature)ZAWABaseLand.this, 1.1, true);
        }

        protected void func_190102_a(EntityLivingBase e, double p_190102_2_) {
            if (e instanceof ZAWABaseLand) {
                ZAWABaseLand za = (ZAWABaseLand)e;
                za.onAttack();
            }
            super.func_190102_a(e, p_190102_2_);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    public static class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final ZAWABaseLand entity;

        public AIAvoidEntity(ZAWABaseLand entity, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super((EntityCreature)entity, classToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
            this.entity = entity;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }
}

