/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.util.ZAWAUtils;

public class EntityAISkilledWander
extends EntityAIBase {
    protected final ZAWABaseLand entity;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected boolean mustUpdate;
    protected boolean paused;
    protected int pauseTime;
    protected int restTime;

    public EntityAISkilledWander(ZAWABaseLand creatureIn, double speedIn) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.paused) {
            ++this.pauseTime;
        }
        if (this.pauseTime > this.restTime) {
            this.paused = false;
        }
        if (this.pauseTime != 0 && this.entity.func_70681_au().nextInt(100) == 4) {
            this.pauseTime = 0;
        }
        if (ZAWAUtils.entityWithinArea((Entity)this.entity, new BlockPos(this.x, this.y, this.z), 5) && this.pauseTime <= this.restTime) {
            this.paused = true;
        }
        if (this.paused) {
            return false;
        }
        if (!this.mustUpdate && this.entity.func_70654_ax() >= 100) {
            return false;
        }
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        return RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)20, (int)7);
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, 4.0 * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        this.entity.func_70671_ap().func_75650_a(this.x, this.y, this.z, 10.0f, 10.0f);
        this.restTime = this.entity.func_70681_au().nextInt(30) + 10;
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }
}

