/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.ai;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import org.zawamod.entity.base.ZAWABaseLand;

public class EntityAIComplexBreeding
extends EntityAIBase {
    private final ZAWABaseLand animal;
    private final Class<? extends ZAWABaseLand> mateClass;
    World world;
    private ZAWABaseLand targetMate;
    int spawnBabyDelay;
    double moveSpeed;

    public EntityAIComplexBreeding(ZAWABaseLand animal, double speedIn) {
        this(animal, speedIn, animal.getClass());
    }

    public EntityAIComplexBreeding(ZAWABaseLand animal, double speed, Class<? extends ZAWABaseLand> animClass) {
        this.animal = animal;
        this.world = animal.field_70170_p;
        this.mateClass = animClass;
        this.moveSpeed = speed;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.animal.func_70880_s()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 50;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.animal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.animal.func_70646_bf());
        this.animal.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed + (double)0.2f);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 50 && this.animal.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    private ZAWABaseLand getNearbyMate() {
        List list = this.world.func_72872_a(this.mateClass, this.animal.func_174813_aQ().func_186662_g(13.0));
        double d0 = Double.MAX_VALUE;
        ZAWABaseLand ZAWABaseLand2 = null;
        for (ZAWABaseLand ZAWABaseLand1 : list) {
            if (!this.animal.func_70878_b((EntityAnimal)ZAWABaseLand1) || !(this.animal.func_70068_e((Entity)ZAWABaseLand1) < d0)) continue;
            ZAWABaseLand2 = ZAWABaseLand1;
            d0 = this.animal.func_70068_e((Entity)ZAWABaseLand1);
        }
        return ZAWABaseLand2;
    }

    private void spawnBaby() {
        ZAWABaseLand entityageable = (ZAWABaseLand)this.animal.func_90011_a((EntityAgeable)this.targetMate);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.animal, (EntityLiving)this.targetMate, (EntityAgeable)entityageable);
        boolean cancelled = false;
        entityageable = (ZAWABaseLand)event.getChild();
        if (entityageable != null) {
            EntityPlayerMP entityplayermp = this.animal.func_191993_do();
            if (entityplayermp == null && this.targetMate.func_191993_do() != null) {
                entityplayermp = this.targetMate.func_191993_do();
            }
            if (entityplayermp != null) {
                entityplayermp.func_71029_a(StatList.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(entityplayermp, (EntityAnimal)this.animal, (EntityAnimal)this.targetMate, (EntityAgeable)entityageable);
            }
            this.animal.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.animal.func_70875_t();
            this.targetMate.func_70875_t();
            if (this.animal.func_70681_au().nextInt(5) != 1) {
                entityageable.setAnimalTrait(this.animal.getTrait());
            }
            if (this.animal.func_70681_au().nextInt(5) != 1) {
                entityageable.setAnimalType(this.animal.getAnimalType());
            }
            entityageable.setParentA(this.animal.getParentA());
            entityageable.setParentB(this.targetMate.getParentB());
            entityageable.func_70873_a(-24000);
            entityageable.func_70012_b(this.animal.field_70165_t, this.animal.field_70163_u, this.animal.field_70161_v, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)entityageable);
            Random random = this.animal.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.animal.field_70130_N * 2.0 - (double)this.animal.field_70130_N;
                double d4 = 0.5 + random.nextDouble() * (double)this.animal.field_70131_O;
                double d5 = random.nextDouble() * (double)this.animal.field_70130_N * 2.0 - (double)this.animal.field_70130_N;
                this.world.func_175688_a(EnumParticleTypes.HEART, this.animal.field_70165_t + d3, this.animal.field_70163_u + d4, this.animal.field_70161_v + d5, d0, d1, d2, new int[0]);
            }
            if (this.world.func_82736_K().func_82766_b("doMobLoot")) {
                this.world.func_72838_d((Entity)new EntityXPOrb(this.world, this.animal.field_70165_t, this.animal.field_70163_u, this.animal.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }
}

