/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.configuration;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.zawamod.entity.flying.EntityAlbatross;
import org.zawamod.entity.flying.EntityAndeanCondor;
import org.zawamod.entity.flying.EntityCockatoo;
import org.zawamod.entity.flying.EntityMacaw;
import org.zawamod.entity.flying.EntityToucan;
import org.zawamod.entity.land.EntityAfricanLion;
import org.zawamod.entity.land.EntityAmurLeopard;
import org.zawamod.entity.land.EntityAsianElephant;
import org.zawamod.entity.land.EntityBengalTiger;
import org.zawamod.entity.land.EntityBlackRhinoceros;
import org.zawamod.entity.land.EntityBlackSpiderMonkey;
import org.zawamod.entity.land.EntityFijiBandedIguana;
import org.zawamod.entity.land.EntityGaur;
import org.zawamod.entity.land.EntityGreenAnaconda;
import org.zawamod.entity.land.EntityGrevysZebra;
import org.zawamod.entity.land.EntityIndianGharial;
import org.zawamod.entity.land.EntityIndianPangolin;
import org.zawamod.entity.land.EntityJapaneseGiantSalamander;
import org.zawamod.entity.land.EntityKoala;
import org.zawamod.entity.land.EntityLowlandGorilla;
import org.zawamod.entity.land.EntityMeerkat;
import org.zawamod.entity.land.EntityNileHippo;
import org.zawamod.entity.land.EntityOkapi;
import org.zawamod.entity.land.EntityPolarBear;
import org.zawamod.entity.land.EntityRedKangaroo;
import org.zawamod.entity.land.EntityRedPanda;
import org.zawamod.entity.land.EntityReticulatedGiraffe;
import org.zawamod.entity.land.EntityTreeFrog;
import org.zawamod.entity.npc.EntityAnimalTrader;
import org.zawamod.entity.npc.EntityFeedTrader;
import org.zawamod.entity.npc.EntityZooKeeper;
import org.zawamod.entity.water.EntityBottlenoseDolphin;
import org.zawamod.entity.water.EntityClownFish;
import org.zawamod.entity.water.EntityFish;
import org.zawamod.entity.water.EntityHawksbillSeaTurtle;
import org.zawamod.entity.water.EntityOrca;
import org.zawamod.entity.water.EntityPacificWalrus;
import org.zawamod.entity.water.EntityPufferFish;
import org.zawamod.entity.water.EntitySockeyeSalmon;
import org.zawamod.util.SpawnData;
import org.zawamod.util.SpawnableAnimal;

public class ZAWASpawnConfig {
    public static Configuration spawnConfig = new Configuration(new File("config/ZooAndWildAnimalsRebuilt/ZAWAAnimalSpawnConfigurations.cfg"));
    public static List<Biome> biomes;
    public static List<SpawnData> spawns;

    public static void init(FMLPreInitializationEvent event) {
        biomes = new ArrayList<Biome>();
        for (Map.Entry b : ForgeRegistries.BIOMES.getEntries()) {
            biomes.add((Biome)b.getValue());
        }
        spawnConfig.load();
        spawnConfig.get("#Comments", "1", "If you want to disable all spawns go to the ZaWAR.cfg and disable it there, it will be more effective!");
        ArrayList animals = Lists.newArrayList();
        animals.add(new SpawnableAnimal(EntityZooKeeper.class, "ZooKeeper", 30, 0, 1, EnumCreatureType.CREATURE, SpawnData.removeBiomes(biomes.toArray(new Biome[biomes.size()]), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER))));
        animals.add(new SpawnableAnimal(EntityAnimalTrader.class, "AnimalTrader", 30, 0, 1, EnumCreatureType.CREATURE, SpawnData.removeBiomes(biomes.toArray(new Biome[biomes.size()]), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER))));
        animals.add(new SpawnableAnimal(EntityFeedTrader.class, "FeedTrader", 30, 0, 1, EnumCreatureType.CREATURE, SpawnData.removeBiomes(biomes.toArray(new Biome[biomes.size()]), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER))));
        animals.add(new SpawnableAnimal(EntityMeerkat.class, "Meerkat", 40, 3, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY)})));
        animals.add(new SpawnableAnimal(EntityAsianElephant.class, "AsianElephant", 34, 3, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS)})));
        animals.add(new SpawnableAnimal(EntityFish.class, "Fish", 90, 1, 6, EnumCreatureType.WATER_CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER)})));
        animals.add(new SpawnableAnimal(EntitySockeyeSalmon.class, "SockeyeSalmon", 60, 1, 6, EnumCreatureType.WATER_CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER), SpawnData.getBiomesOfType(BiomeDictionary.Type.RIVER)})));
        animals.add(new SpawnableAnimal(EntityClownFish.class, "ClownFish", 30, 1, 6, EnumCreatureType.WATER_CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER)})));
        animals.add(new SpawnableAnimal(EntityPufferFish.class, "PufferFish", 40, 1, 6, EnumCreatureType.WATER_CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER)})));
        animals.add(new SpawnableAnimal(EntityAmurLeopard.class, "AmurLeopard", 10, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.MOUNTAIN), SpawnData.getBiomesOfType(BiomeDictionary.Type.SNOWY), SpawnData.getBiomesOfType(BiomeDictionary.Type.CONIFEROUS), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD)})));
        animals.add(new SpawnableAnimal(EntityKoala.class, "Koala", 45, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.FOREST), SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP)})));
        animals.add(new SpawnableAnimal(EntityRedKangaroo.class, "RedKangaroo", 60, 4, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.DEAD), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY)})));
        animals.add(new SpawnableAnimal(EntityGaur.class, "Gaur", 25, 3, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.FOREST), SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH)})));
        animals.add(new SpawnableAnimal(EntityBengalTiger.class, "BengalTiger", 10, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP)})));
        animals.add(new SpawnableAnimal(EntityAfricanLion.class, "AfricanLion", 20, 3, 4, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.mergeBiomes(SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE)), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY)})));
        animals.add(new SpawnableAnimal(EntityCockatoo.class, "Cockatoo", 25, 4, 6, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP), SpawnData.getBiomesOfType(BiomeDictionary.Type.HILLS)})));
        animals.add(new SpawnableAnimal(EntityTreeFrog.class, "TreeFrog", 70, 2, 4, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.FOREST), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP)})));
        animals.add(new SpawnableAnimal(EntityToucan.class, "Toucan", 25, 4, 6, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE)})));
        animals.add(new SpawnableAnimal(EntityRedPanda.class, "RedPanda", 10, 1, 2, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.CONIFEROUS), SpawnData.getBiomesOfType(BiomeDictionary.Type.MOUNTAIN)})));
        animals.add(new SpawnableAnimal(EntityAndeanCondor.class, "AndeanCondor", 30, 1, 2, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD), SpawnData.getBiomesOfType(BiomeDictionary.Type.CONIFEROUS), SpawnData.getBiomesOfType(BiomeDictionary.Type.MOUNTAIN)})));
        animals.add(new SpawnableAnimal(EntityAlbatross.class, "Albatross", 20, 1, 2, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.BEACH)})));
        animals.add(new SpawnableAnimal(EntityPolarBear.class, "PolarBear", 10, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD), SpawnData.getBiomesOfType(BiomeDictionary.Type.CONIFEROUS), SpawnData.getBiomesOfType(BiomeDictionary.Type.SNOWY)})));
        animals.add(new SpawnableAnimal(EntityOrca.class, "Orca", 10, 2, 4, EnumCreatureType.WATER_CREATURE, SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN)));
        animals.add(new SpawnableAnimal(EntityHawksbillSeaTurtle.class, "HawksbillSeaTurtle", 5, 1, 1, EnumCreatureType.WATER_CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN), SpawnData.getBiomesOfType(BiomeDictionary.Type.BEACH), SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER)})));
        animals.add(new SpawnableAnimal(EntityNileHippo.class, "NileHippo", 30, 4, 6, EnumCreatureType.CREATURE, SpawnData.removeBiomes(SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.RIVER), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS)}), Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R)));
        animals.add(new SpawnableAnimal(EntityMacaw.class, "Macaw", 30, 4, 6, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP)})));
        animals.add(new SpawnableAnimal(EntityLowlandGorilla.class, "LowlandGorilla", 10, 5, 6, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.HILLS)})));
        animals.add(new SpawnableAnimal(EntityReticulatedGiraffe.class, "ReticulatedGiraffe", 5, 3, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY)})));
        animals.add(new SpawnableAnimal(EntityGrevysZebra.class, "GrevyZebra", 25, 4, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY)})));
        animals.add(new SpawnableAnimal(EntityFijiBandedIguana.class, "FijiBandedIguana", 5, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.BEACH)})));
        animals.add(new SpawnableAnimal(EntityBottlenoseDolphin.class, "BottlenoseDolphin", 10, 3, 5, EnumCreatureType.WATER_CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.WATER), SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN)})));
        animals.add(new SpawnableAnimal(EntityIndianGharial.class, "IndianGharial", 10, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.CONIFEROUS), SpawnData.getBiomesOfType(BiomeDictionary.Type.RIVER), SpawnData.getBiomesOfType(BiomeDictionary.Type.MOUNTAIN)})));
        animals.add(new SpawnableAnimal(EntityBlackRhinoceros.class, "BlackRhinoceros", 40, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.DRY), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.SAVANNA), SpawnData.getBiomesOfType(BiomeDictionary.Type.SANDY), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS)})));
        animals.add(new SpawnableAnimal(EntityBlackSpiderMonkey.class, "BlackSpiderMonkey", 40, 3, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH)})));
        animals.add(new SpawnableAnimal(EntityIndianPangolin.class, "IndianPangolin", 15, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.FOREST), SpawnData.getBiomesOfType(BiomeDictionary.Type.PLAINS)})));
        animals.add(new SpawnableAnimal(EntityJapaneseGiantSalamander.class, "JapaneseGiantSalamander", 5, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.CONIFEROUS), SpawnData.getBiomesOfType(BiomeDictionary.Type.RIVER)})));
        animals.add(new SpawnableAnimal(EntityGreenAnaconda.class, "GreenAnaconda", 10, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.RIVER), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH), SpawnData.getBiomesOfType(BiomeDictionary.Type.SWAMP)})));
        animals.add(new SpawnableAnimal(EntityOkapi.class, "Okapi", 5, 1, 1, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.HOT), SpawnData.getBiomesOfType(BiomeDictionary.Type.WET), SpawnData.getBiomesOfType(BiomeDictionary.Type.DENSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.JUNGLE), SpawnData.getBiomesOfType(BiomeDictionary.Type.LUSH)})));
        animals.add(new SpawnableAnimal(EntityPacificWalrus.class, "PacificWalrus", 30, 3, 5, EnumCreatureType.CREATURE, SpawnData.mergeBiomes(new Biome[][]{SpawnData.getBiomesOfType(BiomeDictionary.Type.COLD), SpawnData.getBiomesOfType(BiomeDictionary.Type.SPARSE), SpawnData.getBiomesOfType(BiomeDictionary.Type.OCEAN)})));
        for (SpawnableAnimal ani : animals) {
            ani.register();
        }
        spawnConfig.save();
    }

    static {
        spawns = new ArrayList<SpawnData>();
    }
}

