/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity.base;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import org.zawamod.client.IBabyModel;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.ZAWABaseLand;

@SideOnly(value=Side.CLIENT)
public abstract class RenderLivingZAWA<T extends EntityLiving>
extends RenderLivingBase<T> {
    public RenderLivingZAWA(RenderManager rendermanagerIn, ModelBase modelbaseIn, float shadowsizeIn) {
        super(rendermanagerIn, modelbaseIn, shadowsizeIn);
        if (this.canBlink()) {
            this.func_177094_a(new LayerBlink(this));
        }
        if (this instanceof IBabyModel) {
            this.func_177094_a(new LayerChild(this, (IBabyModel)((Object)this)));
        }
    }

    public boolean canBlink() {
        return false;
    }

    protected void preRenderCallback(T entitylivingbaseIn, float partialTickTime) {
        ZAWABaseLand e;
        if (entitylivingbaseIn instanceof ZAWABaseLand && !entitylivingbaseIn.func_70631_g_()) {
            float scale = 0.01f;
            if (((ZAWABaseLand)entitylivingbaseIn).affectedBySize()) {
                GlStateManager.func_179152_a((float)((float)((ZAWABaseLand)entitylivingbaseIn).getSizeMultiplier() * scale + 1.0f), (float)((float)((ZAWABaseLand)entitylivingbaseIn).getSizeMultiplier() * scale + 1.0f), (float)((float)((ZAWABaseLand)entitylivingbaseIn).getSizeMultiplier() * scale + 1.0f));
            }
        }
        if (entitylivingbaseIn.func_95999_t().equals("Hanzo")) {
            GlStateManager.func_179094_E();
            int i1 = 25;
            int i = ((EntityLiving)entitylivingbaseIn).field_70173_aa / 25 + entitylivingbaseIn.func_145782_y();
            int j = EnumDyeColor.values().length;
            int k = i % j;
            int l = (i + 1) % j;
            float f = ((float)(((EntityLiving)entitylivingbaseIn).field_70173_aa % 25) + 2.0f) / 25.0f;
            float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
            float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
            GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
            GlStateManager.func_179121_F();
        }
        if (entitylivingbaseIn instanceof ZAWABaseLand && ZAWAConfig.experimental && (e = (ZAWABaseLand)entitylivingbaseIn).isShiny() && e.shinyData != null) {
            GlStateManager.func_179131_c((float)e.shinyData[0], (float)e.shinyData[1], (float)e.shinyData[2], (float)1.0f);
        }
        super.func_77041_b(entitylivingbaseIn, partialTickTime);
    }

    public ResourceLocation getBlinkTexture(T entity) {
        return null;
    }

    public ResourceLocation getBlinkTexture(int variant) {
        return null;
    }

    public ResourceLocation getTextureOfVar(T entity) {
        return BookwormRenderUtils.none;
    }

    public ResourceLocation getTextureOfVar(int variant) {
        return BookwormRenderUtils.none;
    }

    protected boolean canRenderName(T entity) {
        return super.func_177070_b(entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }

    public boolean shouldRender(T livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a(livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity.func_110167_bD() && livingEntity.func_110166_bE() != null) {
            Entity entity = livingEntity.func_110166_bE();
            return camera.func_78546_a(entity.func_184177_bl());
        }
        return false;
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!this.field_188301_f) {
            this.renderLeash(entity, x, y, z, entityYaw, partialTicks);
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    public void setLightmap(T entityLivingIn) {
        int i = entityLivingIn.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    protected void renderLeash(T entityLivingIn, double x, double y, double z, float entityYaw, float partialTicks) {
        Entity entity = entityLivingIn.func_110166_bE();
        if (entity != null) {
            y -= (1.6 - (double)((EntityLiving)entityLivingIn).field_70131_O) * 0.5;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double d0 = this.interpolateValue(entity.field_70126_B, entity.field_70177_z, partialTicks * 0.5f) * 0.01745329238474369;
            double d1 = this.interpolateValue(entity.field_70127_C, entity.field_70125_A, partialTicks * 0.5f) * 0.01745329238474369;
            double d2 = Math.cos(d0);
            double d3 = Math.sin(d0);
            double d4 = Math.sin(d1);
            if (entity instanceof EntityHanging) {
                d2 = 0.0;
                d3 = 0.0;
                d4 = -1.0;
            }
            double d5 = Math.cos(d1);
            double d6 = this.interpolateValue(entity.field_70169_q, entity.field_70165_t, partialTicks) - d2 * 0.7 - d3 * 0.5 * d5;
            double d7 = this.interpolateValue(entity.field_70167_r + (double)entity.func_70047_e() * 0.7, entity.field_70163_u + (double)entity.func_70047_e() * 0.7, partialTicks) - d4 * 0.5 - 0.25;
            double d8 = this.interpolateValue(entity.field_70166_s, entity.field_70161_v, partialTicks) - d3 * 0.7 + d2 * 0.5 * d5;
            double d9 = this.interpolateValue(((EntityLiving)entityLivingIn).field_70760_ar, ((EntityLiving)entityLivingIn).field_70761_aq, partialTicks) * 0.01745329238474369 + 1.5707963267948966;
            d2 = Math.cos(d9) * (double)((EntityLiving)entityLivingIn).field_70130_N * 0.4;
            d3 = Math.sin(d9) * (double)((EntityLiving)entityLivingIn).field_70130_N * 0.4;
            double d10 = this.interpolateValue(((EntityLiving)entityLivingIn).field_70169_q, ((EntityLiving)entityLivingIn).field_70165_t, partialTicks) + d2;
            double d11 = this.interpolateValue(((EntityLiving)entityLivingIn).field_70167_r, ((EntityLiving)entityLivingIn).field_70163_u, partialTicks);
            double d12 = this.interpolateValue(((EntityLiving)entityLivingIn).field_70166_s, ((EntityLiving)entityLivingIn).field_70161_v, partialTicks) + d3;
            x += d2;
            z += d3;
            double d13 = (float)(d6 - d10);
            double d14 = (float)(d7 - d11);
            double d15 = (float)(d8 - d12);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            int i = 24;
            double d16 = 0.025;
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int j = 0; j <= 24; ++j) {
                float f = 0.5f;
                float f1 = 0.4f;
                float f2 = 0.3f;
                if (j % 2 == 0) {
                    f *= 0.7f;
                    f1 *= 0.7f;
                    f2 *= 0.7f;
                }
                float f3 = (float)j / 24.0f;
                bufferbuilder.func_181662_b(x + d13 * (double)f3 + 0.0, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + d13 * (double)f3 + 0.025, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int k = 0; k <= 24; ++k) {
                float f4 = 0.5f;
                float f5 = 0.4f;
                float f6 = 0.3f;
                if (k % 2 == 0) {
                    f4 *= 0.7f;
                    f5 *= 0.7f;
                    f6 *= 0.7f;
                }
                float f7 = (float)k / 24.0f;
                bufferbuilder.func_181662_b(x + d13 * (double)f7 + 0.0, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f7).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + d13 * (double)f7 + 0.025, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), z + d15 * (double)f7 + 0.025).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
        }
    }

    protected boolean bindEntityTexture(T entity) {
        ResourceLocation resourcelocation = this.func_110775_a((Entity)entity);
        if (resourcelocation == null) {
            return false;
        }
        if (entity instanceof ZAWABaseLand && this instanceof IBabyModel) {
            ZAWABaseLand e = (ZAWABaseLand)entity;
            this.func_110776_a(e.func_70631_g_() ? BookwormRenderUtils.none : resourcelocation);
        } else {
            this.func_110776_a(resourcelocation);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerChild
    implements LayerRenderer<ZAWABaseLand> {
        private final RenderLivingZAWA render;
        private final IBabyModel<ZAWABaseLand> ibaby;
        private final ModelBase modelF;

        public LayerChild(RenderLivingZAWA re, IBabyModel<ZAWABaseLand> ibaby) {
            this.ibaby = ibaby;
            this.render = re;
            this.modelF = ibaby.getBabyModel();
        }

        public void doRenderLayer(ZAWABaseLand e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (e.func_70631_g_() && !e.func_82150_aj()) {
                this.ibaby.preRender(e, this.render);
                this.render.func_110776_a(this.ibaby.getBabyTexture(e));
                this.modelF.func_178686_a(this.render.func_177087_b());
                this.modelF.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)e);
                this.modelF.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
                this.ibaby.postRender(e, this.render);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerBlink
    implements LayerRenderer<ZAWABaseLand> {
        private final RenderLivingZAWA render;

        public LayerBlink(RenderLivingZAWA re) {
            this.render = re;
        }

        public void doRenderLayer(ZAWABaseLand e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (!e.func_82150_aj() && (e.getBlinking() || e.isTranquilized()) && !e.func_70631_g_() && this.render.getBlinkTexture(e) != null) {
                GlStateManager.func_179094_E();
                this.render.func_110776_a(this.render.getBlinkTexture(e));
                this.render.func_177087_b().func_178686_a(this.render.func_177087_b());
                this.render.func_177087_b().func_78087_a(f, f1, f3, f4, f5, f6, (Entity)e);
                this.render.func_177087_b().func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

