/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.model.part;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.client.model.part.AdvancedModelRenderer;

@SideOnly(value=Side.CLIENT)
public class AdvancedModelBase
extends ModelBase {
    public final float movementScale = 1.0f;

    public AdvancedModelRenderer getPartByName(String name) {
        for (ModelRenderer part : this.field_78092_r) {
            if (!((AdvancedModelRenderer)part).name.equals(name)) continue;
            return (AdvancedModelRenderer)part;
        }
        return null;
    }

    public void updateDefaultPose() {
        for (int i = 0; i < this.field_78092_r.size(); ++i) {
            ((AdvancedModelRenderer)((Object)this.field_78092_r.get((int)i))).name = ((Object)((Object)this)).getClass().getFields()[i].getName();
            ((AdvancedModelRenderer)((Object)this.field_78092_r.get(i))).updateDefaultPose();
        }
    }

    public void reset() {
        for (int i = 0; i < this.field_78092_r.size(); ++i) {
            ((AdvancedModelRenderer)((Object)this.field_78092_r.get(i))).reset();
        }
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, AdvancedModelRenderer ... boxes) {
        float actualRotationDivisor = rotationDivisor * (float)boxes.length;
        float yawAmount = yaw / 57.295776f / actualRotationDivisor;
        float pitchAmount = pitch / 57.295776f / actualRotationDivisor;
        for (AdvancedModelRenderer box : boxes) {
            box.field_78796_g += yawAmount;
            box.field_78795_f += pitchAmount;
        }
    }

    public void chainSwing(AdvancedModelRenderer[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78796_g += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainWave(AdvancedModelRenderer[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78795_f += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainFlap(AdvancedModelRenderer[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78808_h += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    private float calculateChainRotation(float speed, float degree, float swing, float swingAmount, float offset, int boxIndex) {
        return MathHelper.func_76134_b((float)(swing * (speed * this.movementScale) + offset * (float)boxIndex)) * swingAmount * (degree * this.movementScale);
    }

    private float calculateChainOffset(double rootOffset, AdvancedModelRenderer ... boxes) {
        return (float)(rootOffset * Math.PI / (double)(2 * boxes.length));
    }

    public float getMovementScale() {
        return this.movementScale;
    }

    public void walk(AdvancedModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.walk(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(AdvancedModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        box.flap(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(AdvancedModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        box.swing(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(AdvancedModelRenderer box, float speed, float degree, boolean bounce, float f, float f1) {
        box.bob(speed, degree, bounce, f, f1);
    }

    public float moveBox(float speed, float degree, boolean bounce, float f, float f1) {
        if (bounce) {
            return -MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)(f * speed)) * f1 * degree));
        }
        return MathHelper.func_76126_a((float)(f * speed)) * f1 * degree - f1 * degree;
    }
}

