/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zawamod.init.ZAWABlocks;
import org.zawamod.init.ZAWAItems;
import org.zawamod.init.items.ItemSpawnEggZAWA;
import org.zawamod.init.items.ItemZAWAVial;
import org.zawamod.proxy.CommonProxy;

@Mod(modid="zawa", name="Zoo and Wild Animals", version="1.12-1.5.5", dependencies="required-before:bookworm@[1.12-2.1.0,);", updateJSON="https://raw.githubusercontent.com/ZAWAMod/ZAWAMod.github.io/master/112update.json", certificateFingerprint="3ee471ded1bba54aa82f4f5ca5ca82dd67b8ef42", acceptedMinecraftVersions="[1.12]")
public class ZAWAMain {
    public static DamageSource electricFence = new DamageSource("elecfence").func_76348_h();
    public static DamageSource depression = new DamageSource("depression").func_76348_h();
    public static final Logger logger = LogManager.getLogger((String)"zawa");
    @SidedProxy(serverSide="org.zawamod.proxy.CommonProxy", clientSide="org.zawamod.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="zawa")
    public static ZAWAMain instance;
    public static final CreativeTabs zawaTabItems;
    public static final CreativeTabs zawaTabPlants;
    public static final CreativeTabs zawaTabDrops;
    public static final CreativeTabs zawaTabDecor;
    public static final CreativeTabs zawaTabEntity;
    public static final CreativeTabs zawaTabBreeding;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        proxy.registerRenders();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        logger.warn("Invalid fingerprint detected : Use caution using the zawa build as it was not built by a zawa author!");
    }

    static {
        zawaTabItems = new CreativeTabs("zawa_tab_items"){

            public ItemStack func_78016_d() {
                return new ItemStack(ZAWAItems.BEAR_KIBBLE);
            }
        };
        zawaTabPlants = new CreativeTabs("zawa_tab_plants"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)ZAWABlocks.STAGHORN_CORAL));
            }
        };
        zawaTabDrops = new CreativeTabs("zawa_tab_drops"){

            public ItemStack func_78016_d() {
                return new ItemStack(ZAWAItems.FUR);
            }
        };
        zawaTabDecor = new CreativeTabs("zawa_tab_decor"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)ZAWABlocks.BAMBOO_DECORTATION));
            }
        };
        zawaTabEntity = new CreativeTabs("zawa_tab_entity"){

            public ItemStack func_78016_d() {
                ArrayList<Item> items = new ArrayList<Item>();
                for (Item im : ZAWAItems.ITEMS) {
                    if (!(im instanceof ItemSpawnEggZAWA)) continue;
                    items.add(im);
                }
                return new ItemStack((Item)items.get(new Random().nextInt(items.size())));
            }
        };
        zawaTabBreeding = new CreativeTabs("zawa_tab_breeding"){

            public ItemStack func_78016_d() {
                ArrayList<Item> items = new ArrayList<Item>();
                for (Item im : ZAWAItems.ITEMS) {
                    if (!(im instanceof ItemZAWAVial)) continue;
                    items.add(im);
                }
                return new ItemStack((Item)items.get(new Random().nextInt(items.size())));
            }
        };
    }
}

