/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.XMLOreLoader;

public class XMLPlanetLoader {
    Document doc = null;
    NodeList currentList;
    int currentNodeIndex = -1;
    int starId = 0;
    int offset;
    HashMap<StellarBody, Integer> maxPlanetNumber = new HashMap();
    HashMap<StellarBody, Integer> maxGasPlanetNumber = new HashMap();

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.doc != null;
    }

    public int getMaxNumPlanets(StellarBody body) {
        if (!this.maxPlanetNumber.containsKey(body)) {
            AdvancedRocketry.logger.warn("Star ID " + body.getId() + " has no entry for numPlanets");
            return 0;
        }
        return this.maxPlanetNumber.get(body);
    }

    public int getMaxNumGasGiants(StellarBody body) {
        if (!this.maxGasPlanetNumber.containsKey(body)) {
            AdvancedRocketry.logger.warn("Star ID " + body.getId() + " has no entry for numGasGiants");
            return 0;
        }
        return this.maxGasPlanetNumber.get(body);
    }

    private List<DimensionProperties> readPlanetFromNode(Node planetNode, StellarBody star) {
        ArrayList<DimensionProperties> list = new ArrayList<DimensionProperties>();
        Node planetPropertyNode = planetNode.getFirstChild();
        DimensionProperties properties = new DimensionProperties(DimensionManager.getInstance().getNextFreeDim(this.offset));
        if (properties == null) {
            return list;
        }
        list.add(properties);
        ++this.offset;
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem("name");
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                properties.setName(nameNode.getNodeValue());
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("DIMID")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    if (nameNode.getTextContent().isEmpty()) {
                        throw new NumberFormatException();
                    }
                    properties.setId(Integer.parseInt(nameNode.getTextContent()));
                    --this.offset;
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Invalid DIMID specified for planet " + properties.getName());
                    list.remove(properties);
                    --this.offset;
                    return list;
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("dimMapping")) != null) {
                properties.isNativeDimension = false;
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("customIcon")) != null) {
                properties.customIcon = nameNode.getTextContent();
            }
        }
        while (planetPropertyNode != null) {
            block123: {
                String text;
                String blockName;
                String[] colors;
                if (planetPropertyNode.getNodeName().equalsIgnoreCase("fogcolor")) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (int j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.fogColor = rgb;
                            break block123;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.fogColor = rgb;
                            break block123;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for fog color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid fog color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("gas")) {
                    Fluid f = FluidRegistry.getFluid((String)planetPropertyNode.getTextContent());
                    if (f == null) {
                        AdvancedRocketry.logger.warn("\"" + planetPropertyNode.getTextContent() + "\" is not a valid fluid");
                    } else {
                        properties.getHarvestableGasses().add(f);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("oceanBlock")) {
                    blockName = planetPropertyNode.getTextContent();
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
                    if (block == Blocks.field_150350_a) {
                        AdvancedRocketry.logger.warn("Invalid ocean block: " + blockName);
                    }
                    properties.setOceanBlock(block.func_176223_P());
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("fillerBlock")) {
                    blockName = planetPropertyNode.getTextContent();
                    String[] splitBlockName = blockName.split(":");
                    if (splitBlockName.length < 2) {
                        AdvancedRocketry.logger.warn("Invalid resource location for fillerBlock: " + blockName);
                    } else {
                        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(splitBlockName[0], splitBlockName[1]));
                        int metaValue = 0;
                        if (splitBlockName.length > 2) {
                            try {
                                metaValue = Integer.parseInt(splitBlockName[2]);
                            }
                            catch (NumberFormatException e) {
                                AdvancedRocketry.logger.warn("Invalid meta value location for fillerBlock: " + blockName + " using " + splitBlockName[2]);
                            }
                        }
                        if (block == Blocks.field_150350_a) {
                            AdvancedRocketry.logger.warn("Invalid filler block: " + blockName);
                        }
                        properties.setStoneBlock(block.func_176203_a(metaValue));
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("skycolor")) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (int j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.skyColor = rgb;
                            break block123;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.skyColor = rgb;
                            break block123;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for sky color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sky color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("atmosphereDensity")) {
                    try {
                        properties.setAtmosphereDensityDirect(Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 200));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid atmosphereDensity specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("gravitationalmultiplier")) {
                    try {
                        properties.gravitationalMultiplier = (float)Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 200) / 100.0f;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid gravitationalMultiplier specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitaldistance")) {
                    try {
                        properties.orbitalDist = Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 200);
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalDist specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitaltheta")) {
                    try {
                        properties.orbitTheta = (double)(Integer.parseInt(planetPropertyNode.getTextContent()) % 360 * 2) / Math.PI;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalTheta specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("rotationalperiod")) {
                    try {
                        int rotationalPeriod = Integer.parseInt(planetPropertyNode.getTextContent());
                        if (properties.rotationalPeriod > 0) {
                            properties.rotationalPeriod = rotationalPeriod;
                            break block123;
                        }
                        AdvancedRocketry.logger.warn("rotational Period must be greater than 0");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid rotational period specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("seaLevel")) {
                    try {
                        properties.setSeaLevel(Integer.parseInt(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sealeve specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("biomeids")) {
                    String[] biomeList = planetPropertyNode.getTextContent().split(",");
                    for (int j = 0; j < biomeList.length; ++j) {
                        ResourceLocation location = new ResourceLocation(biomeList[j]);
                        if (Biome.field_185377_q.func_148741_d((Object)location)) {
                            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)location);
                            if (biome != null && properties.addBiome(Biome.func_185362_a((Biome)biome))) continue;
                            AdvancedRocketry.logger.warn("Error adding " + biomeList[j]);
                            continue;
                        }
                        try {
                            int biome = Integer.parseInt(biomeList[j]);
                            if (properties.addBiome(biome)) continue;
                            AdvancedRocketry.logger.warn(biomeList[j] + " is not a valid biome id");
                            continue;
                        }
                        catch (NumberFormatException e) {
                            AdvancedRocketry.logger.warn(biomeList[j] + " is not a valid biome id or name");
                        }
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("spawnable")) {
                    Class<?> clazz;
                    int weight = 100;
                    int groupMin = 1;
                    int groupMax = 1;
                    String nbtString = "";
                    Node weightNode = planetPropertyNode.getAttributes().getNamedItem("weight");
                    Node groupMinNode = planetPropertyNode.getAttributes().getNamedItem("groupMin");
                    Node groupMaxNode = planetPropertyNode.getAttributes().getNamedItem("groupMax");
                    Node nbtNode = planetPropertyNode.getAttributes().getNamedItem("nbt");
                    if (weightNode != null) {
                        try {
                            weight = Integer.parseInt(weightNode.getTextContent());
                            weight = Math.max(1, weight);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (groupMinNode != null) {
                        try {
                            groupMin = Integer.parseInt(groupMinNode.getTextContent());
                            groupMin = Math.max(1, groupMin);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (groupMaxNode != null) {
                        try {
                            groupMax = Integer.parseInt(groupMaxNode.getTextContent());
                            groupMax = Math.max(1, groupMax);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (nbtNode != null) {
                        nbtString = nbtNode.getTextContent();
                    }
                    if (groupMax < groupMin) {
                        groupMax = groupMin;
                    }
                    if ((clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(planetPropertyNode.getTextContent()))) == null) {
                        try {
                            clazz = Class.forName(planetPropertyNode.getTextContent());
                            if (clazz != null && !Entity.class.isAssignableFrom(clazz)) {
                                clazz = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (clazz != null) {
                        SpawnListEntryNBT entry = new SpawnListEntryNBT(clazz, weight, groupMin, groupMax);
                        if (!nbtString.isEmpty()) {
                            try {
                                entry.setNbt(nbtString);
                            }
                            catch (DOMException e) {
                                AdvancedRocketry.logger.fatal("===== Configuration Error!  Please check your save's planetDefs.xml config file =====\n" + e.getLocalizedMessage() + "\nThe following is not valid JSON:\n" + nbtString);
                            }
                            catch (NBTException e) {
                                AdvancedRocketry.logger.fatal("===== Configuration Error!  Please check your save's planetDefs.xml config file =====\n" + e.getLocalizedMessage() + "\nThe following is not valid NBT data:\n" + nbtString);
                            }
                        }
                        properties.getSpawnListEntries().add(entry);
                    } else {
                        AdvancedRocketry.logger.warn("Cannot find " + planetPropertyNode.getTextContent() + " while registering entity for planet spawn");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("artifact")) {
                    ItemStack stack = XMLPlanetLoader.getStack(planetPropertyNode.getTextContent());
                    if (stack != null) {
                        properties.getRequiredArtifacts().add(stack);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("planet")) {
                    List<DimensionProperties> childList = this.readPlanetFromNode(planetPropertyNode, star);
                    if (childList.size() > 0) {
                        DimensionProperties child = childList.get(childList.size() - 1);
                        properties.addChildPlanet(child);
                        list.addAll(childList);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitalPhi")) {
                    try {
                        properties.orbitalPhi = (double)(Integer.parseInt(planetPropertyNode.getTextContent()) % 360 * 180) / Math.PI;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalTheta specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("oreGen")) {
                    properties.oreProperties = XMLOreLoader.loadOre(planetPropertyNode);
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("genType")) {
                    try {
                        properties.setGenType(Integer.parseInt(planetPropertyNode.getTextContent()));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid generator type specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("hasRings")) {
                    properties.hasRings = Boolean.parseBoolean(planetPropertyNode.getTextContent());
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("ringColor")) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (int j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.ringColor = rgb;
                            break block123;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.ringColor = rgb;
                            break block123;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for ring color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sky color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("GasGiant")) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty() && text.equalsIgnoreCase("true")) {
                        properties.setGasGiant(true);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("isKnown") && (text = planetPropertyNode.getTextContent()) != null && !text.isEmpty() && text.equalsIgnoreCase("true")) {
                    Configuration.initiallyKnownPlanets.add(properties.getId());
                }
            }
            planetPropertyNode = planetPropertyNode.getNextSibling();
        }
        properties.setStar(star.getId());
        properties.averageTemperature = DimensionManager.getInstance().getTemperature(star, properties.getOrbitalDist(), properties.getAtmosphereDensity());
        if (properties.getBiomes().isEmpty()) {
            properties.addBiomes(properties.getViableBiomes());
        }
        return list;
    }

    public StellarBody readStar(Node planetNode) {
        StellarBody star = this.readSubStar(planetNode);
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem("x");
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setPosX(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("y")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setPosZ(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            nameNode = planetNode.getAttributes().getNamedItem("numPlanets");
            try {
                this.maxPlanetNumber.put(star, Integer.parseInt(nameNode.getNodeValue()));
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Invalid number of planets specified in xml config!");
            }
            nameNode = planetNode.getAttributes().getNamedItem("numGasGiants");
            try {
                this.maxGasPlanetNumber.put(star, Integer.parseInt(nameNode.getNodeValue()));
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Invalid number of planets specified in xml config!");
            }
            nameNode = planetNode.getAttributes().getNamedItem("blackHole");
            if (nameNode != null && nameNode.getNodeValue().equalsIgnoreCase("true")) {
                star.setBlackHole(true);
            }
        }
        star.setId(this.starId++);
        return star;
    }

    public StellarBody readSubStar(Node planetNode) {
        StellarBody star = new StellarBody();
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem("name");
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                star.setName(nameNode.getNodeValue());
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("temp")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setTemperature(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("size")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setSize(Float.parseFloat(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("seperation")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setStarSeperation(Float.parseFloat(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
        }
        return star;
    }

    public DimensionPropertyCoupling readAllPlanets() {
        DimensionPropertyCoupling coupling = new DimensionPropertyCoupling();
        Node masterNode = this.doc.getElementsByTagName("galaxy").item(0).getFirstChild();
        this.offset = DimensionManager.dimOffset;
        while (masterNode != null) {
            if (!masterNode.getNodeName().equals("star")) {
                masterNode = masterNode.getNextSibling();
                continue;
            }
            StellarBody star = this.readStar(masterNode);
            coupling.stars.add(star);
            NodeList planetNodeList = masterNode.getChildNodes();
            for (Node planetNode = planetNodeList.item(0); planetNode != null; planetNode = planetNode.getNextSibling()) {
                if (planetNode.getNodeName().equalsIgnoreCase("planet")) {
                    coupling.dims.addAll(this.readPlanetFromNode(planetNode, star));
                }
                if (!planetNode.getNodeName().equalsIgnoreCase("star")) continue;
                StellarBody star2 = this.readSubStar(planetNode);
                star.addSubStar(star2);
            }
            masterNode = masterNode.getNextSibling();
        }
        return coupling;
    }

    public static String writeXML(IGalaxy galaxy) {
        String outputString = "<galaxy>\n";
        Collection<StellarBody> stars = galaxy.getStars();
        for (StellarBody star : stars) {
            String blackHoleBit = "";
            blackHoleBit = star.isBlackHole() ? "blackHole=\"" + star.isBlackHole() + "\"" : "";
            outputString = outputString + "\t<star name=\"" + star.getName() + "\" temp=\"" + star.getTemperature() + "\" x=\"" + star.getPosX() + "\" y=\"" + star.getPosZ() + "\" size=\"" + star.getSize() + "\" numPlanets=\"0\" numGasGiants=\"0\" " + blackHoleBit + ">\n";
            for (StellarBody star2 : star.getSubStars()) {
                blackHoleBit = star2.isBlackHole() ? "blackHole=\"" + star2.isBlackHole() + "\"" : "";
                outputString = outputString + "\t\t<star temp=\"" + star2.getTemperature() + "\" size=\"" + star2.getSize() + "\" seperation=\"" + star2.getStarSeperation() + "\"" + blackHoleBit + " />\n";
            }
            for (IDimensionProperties properties : star.getPlanets()) {
                if (properties.isMoon()) continue;
                outputString = outputString + XMLPlanetLoader.writePlanet((DimensionProperties)properties, 2);
            }
            outputString = outputString + "\t</star>\n";
        }
        outputString = outputString + "</galaxy>";
        return outputString;
    }

    private static String writePlanet(DimensionProperties properties, int numTabs) {
        String outputString = "";
        String tabLen = "";
        for (int i = 0; i < numTabs; ++i) {
            tabLen = tabLen + "\t";
        }
        outputString = tabLen + "<planet name=\"" + properties.getName() + "\" DIMID=\"" + properties.getId() + "\"" + (properties.isNativeDimension ? "" : " dimMapping=\"\"") + (properties.customIcon.isEmpty() ? "" : " customIcon=\"" + properties.customIcon + "\"") + ">\n";
        outputString = outputString + tabLen + "\t<isKnown>" + Configuration.initiallyKnownPlanets.contains(properties.getId()) + "</isKnown>\n";
        if (properties.hasRings) {
            outputString = outputString + tabLen + "\t<hasRings>true</hasRings>\n";
            outputString = outputString + tabLen + "\t<ringColor>" + properties.ringColor[0] + "," + properties.ringColor[1] + "," + properties.ringColor[2] + "</ringColor>\n";
        }
        if (properties.isGasGiant()) {
            outputString = outputString + tabLen + "\t<GasGiant>true</GasGiant>\n";
            if (!properties.getHarvestableGasses().isEmpty()) {
                for (Fluid fluid : properties.getHarvestableGasses()) {
                    outputString = outputString + tabLen + "\t<gas>" + fluid.getName() + "</gas>\n";
                }
            }
        }
        outputString = outputString + tabLen + "\t<fogColor>" + properties.fogColor[0] + "," + properties.fogColor[1] + "," + properties.fogColor[2] + "</fogColor>\n";
        outputString = outputString + tabLen + "\t<skyColor>" + properties.skyColor[0] + "," + properties.skyColor[1] + "," + properties.skyColor[2] + "</skyColor>\n";
        outputString = outputString + tabLen + "\t<gravitationalMultiplier>" + (int)(properties.getGravitationalMultiplier() * 100.0f) + "</gravitationalMultiplier>\n";
        outputString = outputString + tabLen + "\t<orbitalDistance>" + properties.getOrbitalDist() + "</orbitalDistance>\n";
        outputString = outputString + tabLen + "\t<orbitalPhi>" + (int)(properties.orbitalPhi * Math.PI / 180.0) + "</orbitalPhi>\n";
        outputString = outputString + tabLen + "\t<rotationalPeriod>" + properties.rotationalPeriod + "</rotationalPeriod>\n";
        outputString = outputString + tabLen + "\t<atmosphereDensity>" + properties.getAtmosphereDensity() + "</atmosphereDensity>\n";
        if (properties.getSeaLevel() != 63) {
            outputString = outputString + tabLen + "\t<seaLevel>" + properties.getSeaLevel() + "</seaLevel>\n";
        }
        if (properties.getGenType() != 0) {
            outputString = outputString + tabLen + "\t<genType>" + properties.getGenType() + "</genType>\n";
        }
        if (properties.oreProperties != null) {
            outputString = outputString + tabLen + "\t<oreGen>\n";
            outputString = outputString + XMLOreLoader.writeOreEntryXML(properties.oreProperties, numTabs + 2);
            outputString = outputString + tabLen + "\t</oreGen>\n";
        }
        if (properties.isNativeDimension && !properties.isGasGiant()) {
            String biomeIds = "";
            for (BiomeManager.BiomeEntry biome : properties.getBiomes()) {
                try {
                    biomeIds = biomeIds + "," + ((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome.biome)).toString();
                }
                catch (NullPointerException e) {
                    AdvancedRocketry.logger.warn("Error saving biomes for world, biomes list saved may be incomplete.  World: " + properties.getId());
                }
            }
            if (!biomeIds.isEmpty()) {
                biomeIds = biomeIds.substring(1);
            } else {
                AdvancedRocketry.logger.warn("Dim " + properties.getId() + " has no biomes to save!");
            }
            outputString = outputString + tabLen + "\t<biomeIds>" + biomeIds + "</biomeIds>\n";
        }
        for (ItemStack itemStack : properties.getRequiredArtifacts()) {
            outputString = outputString + tabLen + "\t<artifact>" + itemStack.func_77973_b().getRegistryName() + " " + itemStack.func_77952_i() + " " + itemStack.func_190916_E() + "</artifact>\n";
        }
        for (Integer n : properties.getChildPlanets()) {
            outputString = outputString + XMLPlanetLoader.writePlanet(DimensionManager.getInstance().getDimensionProperties(n), numTabs + 1);
        }
        if (properties.getOceanBlock() != null) {
            outputString = outputString + tabLen + "\t<oceanBlock>" + Block.field_149771_c.func_177774_c((Object)properties.getOceanBlock().func_177230_c()) + "</oceanBlock>\n";
        }
        if (properties.getStoneBlock() != null) {
            int meta = properties.getStoneBlock().func_177230_c().func_176201_c(properties.getStoneBlock());
            outputString = meta != 0 ? outputString + tabLen + "\t<fillerBlock>" + Block.field_149771_c.func_177774_c((Object)properties.getStoneBlock().func_177230_c()) + ":" + meta + "</fillerBlock>\n" : outputString + tabLen + "\t<fillerBlock>" + Block.field_149771_c.func_177774_c((Object)properties.getStoneBlock().func_177230_c()) + "</fillerBlock>\n";
        }
        for (SpawnListEntryNBT spawnListEntryNBT : properties.getSpawnListEntries()) {
            String nbtString = spawnListEntryNBT.getNBTString();
            if (!nbtString.isEmpty()) {
                nbtString = " nbt=\"" + nbtString + "\"";
            }
            outputString = outputString + tabLen + "\t<spawnable weight=\"" + spawnListEntryNBT.field_76292_a + "\" groupMin=\"" + spawnListEntryNBT.field_76301_c + "\" groupMax=\"" + spawnListEntryNBT.field_76299_d + "\"" + nbtString + ">" + EntityRegistry.getEntry((Class)spawnListEntryNBT.field_76300_b).getRegistryName() + "</spawnable>\n";
        }
        outputString = outputString + tabLen + "</planet>\n";
        return outputString;
    }

    public static ItemStack getStack(String text) {
        String[] splitStr = text.split(" ");
        int meta = 0;
        int size = 1;
        if (splitStr.length > 1) {
            try {
                meta = Integer.parseInt(splitStr[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (splitStr.length > 2) {
                try {
                    size = Integer.parseInt(splitStr[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        ItemStack stack = null;
        Block block = Block.func_149684_b((String)splitStr[0]);
        if (block == null) {
            Item item = Item.func_111206_d((String)splitStr[0]);
            if (item != null) {
                stack = new ItemStack(item, size, meta);
            }
        } else {
            stack = new ItemStack(block, size, meta);
        }
        return stack;
    }

    public static class DimensionPropertyCoupling {
        public List<StellarBody> stars = new LinkedList<StellarBody>();
        public List<DimensionProperties> dims = new LinkedList<DimensionProperties>();
    }
}

