/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.oxygen;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.tile.oxygen.TileCO2Scrubber;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IToggleableMachine;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.client.RepeatingSound;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumerTank;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.IAdjBlockUpdate;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileOxygenVent
extends TileInventoriedRFConsumerTank
implements IBlobHandler,
IModularInventory,
INetworkMachine,
IAdjBlockUpdate,
IToggleableMachine,
IButtonInventory,
IToggleButton {
    boolean isSealed;
    boolean firstRun;
    boolean hasFluid;
    boolean soundInit;
    boolean allowTrace;
    int numScrubbers;
    List<TileCO2Scrubber> scrubbers;
    int radius = 0;
    static final byte PACKET_REDSTONE_ID = 2;
    static final byte PACKET_TRACE_ID = 3;
    ZUtils.RedstoneState state;
    ModuleRedstoneOutputButton redstoneControl;
    ModuleToggleSwitch traceToggle;

    public TileOxygenVent() {
        super(1000, 2, 1000);
        this.isSealed = true;
        this.firstRun = true;
        this.hasFluid = true;
        this.soundInit = false;
        this.allowTrace = false;
        this.numScrubbers = 0;
        this.scrubbers = new LinkedList<TileCO2Scrubber>();
        this.state = ZUtils.RedstoneState.ON;
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, 2, "", (IButtonInventory)this);
        this.traceToggle = new ModuleToggleSwitch(80, 20, 3, LibVulpes.proxy.getLocalizedString("msg.vent.trace"), (IToggleButton)this, TextureResources.buttonGeneric, 80, 18, false);
    }

    public TileOxygenVent(int energy, int invSize, int tankSize) {
        super(energy, invSize, tankSize);
        this.isSealed = false;
        this.firstRun = false;
        this.hasFluid = true;
        this.soundInit = false;
        this.allowTrace = false;
        this.scrubbers = new LinkedList<TileCO2Scrubber>();
        this.state = ZUtils.RedstoneState.ON;
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this);
        this.traceToggle = new ModuleToggleSwitch(80, 20, 5, LibVulpes.proxy.getLocalizedString("msg.vent.trace"), (IToggleButton)this, TextureResources.buttonGeneric, 80, 18, false);
    }

    public boolean canPerformFunction() {
        return AtmosphereHandler.hasAtmosphereHandler(this.field_145850_b.field_73011_w.getDimension());
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    public void onAdjacentBlockUpdated() {
        if (this.isSealed) {
            this.activateAdjblocks();
        }
        this.scrubbers.clear();
        TileEntity[] tiles = new TileEntity[]{this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 0)), this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, 0)), this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 1)), this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -1))};
        for (TileEntity tile : tiles) {
            if (!(tile instanceof TileCO2Scrubber) || this.field_145850_b.func_180495_p(tile.func_174877_v()).func_177230_c() != AdvancedRocketryBlocks.blockOxygenScrubber) continue;
            this.scrubbers.add((TileCO2Scrubber)tile);
        }
    }

    private void activateAdjblocks() {
        this.numScrubbers = 0;
        this.numScrubbers = this.toggleAdjBlock(this.field_174879_c.func_177982_a(1, 0, 0), true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.numScrubbers = this.toggleAdjBlock(this.field_174879_c.func_177982_a(-1, 0, 0), true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.numScrubbers = this.toggleAdjBlock(this.field_174879_c.func_177982_a(0, 0, 1), true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.numScrubbers = this.toggleAdjBlock(this.field_174879_c.func_177982_a(0, 0, -1), true) ? this.numScrubbers + 1 : this.numScrubbers;
    }

    private void deactivateAdjblocks() {
        this.toggleAdjBlock(this.field_174879_c.func_177982_a(1, 0, 0), false);
        this.toggleAdjBlock(this.field_174879_c.func_177982_a(-1, 0, 0), false);
        this.toggleAdjBlock(this.field_174879_c.func_177982_a(0, 0, 1), false);
        this.toggleAdjBlock(this.field_174879_c.func_177982_a(0, 0, -1), false);
    }

    private boolean toggleAdjBlock(BlockPos pos, boolean on) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == AdvancedRocketryBlocks.blockOxygenScrubber) {
            ((BlockTile)block).setBlockState(this.field_145850_b, state, pos, on);
            return true;
        }
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension());
        if (handler != null) {
            AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).unregisterBlob(this);
        }
        this.deactivateAdjblocks();
    }

    public int getPowerPerOperation() {
        return (int)((double)(this.numScrubbers * 10 + 1) * Configuration.oxygenVentPowerMultiplier);
    }

    public boolean canFill(Fluid fluid) {
        return FluidUtils.areFluidsSameType((Fluid)fluid, (Fluid)AdvancedRocketryFluids.fluidOxygen) && super.canFill(fluid);
    }

    public boolean getEquivilentPower() {
        boolean state2;
        if (this.state == ZUtils.RedstoneState.OFF) {
            return true;
        }
        boolean bl = state2 = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        if (this.state == ZUtils.RedstoneState.INVERTED) {
            state2 = !state2;
        }
        return state2;
    }

    public void performFunction() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.firstRun) {
                AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).registerBlob(this, this.field_174879_c);
                this.onAdjacentBlockUpdated();
                this.setSealed(false);
                this.firstRun = false;
            }
            if (this.isSealed && AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).getBlobSize(this) == 0) {
                this.deactivateAdjblocks();
                this.setSealed(false);
            }
            if (this.isSealed && !this.getEquivilentPower()) {
                AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).clearBlob(this);
                this.deactivateAdjblocks();
                this.setSealed(false);
            } else if (!this.isSealed && this.getEquivilentPower() && this.hasEnoughEnergy(this.getPowerPerOperation())) {
                this.setSealed(AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).addBlock(this, new HashedBlockPosition(this.field_174879_c)));
                if (this.isSealed) {
                    this.activateAdjblocks();
                } else if (this.field_145850_b.func_82737_E() % 10L == 0L && this.allowTrace) {
                    ++this.radius;
                    if (this.radius > 128) {
                        this.radius = 0;
                    }
                }
            }
            if (this.isSealed) {
                FluidStack drainedFluid;
                float amtToDrain;
                if (Configuration.scrubberRequiresCartrige && this.field_145850_b.func_82737_E() % 200L == 0L) {
                    this.numScrubbers = 0;
                    for (TileCO2Scrubber scrubber : this.scrubbers) {
                        this.numScrubbers = scrubber.useCharge() ? this.numScrubbers + 1 : this.numScrubbers;
                    }
                }
                if ((amtToDrain = (float)AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).getBlobSize(this) * this.getGasUsageMultiplier()) > 0.0f && amtToDrain < 1.0f) {
                    amtToDrain = 1.0f;
                }
                if ((drainedFluid = this.drain((int)amtToDrain, false)) != null && (float)drainedFluid.amount >= amtToDrain || amtToDrain == 0.0f) {
                    this.drain((int)amtToDrain, true);
                    if (!this.hasFluid) {
                        this.hasFluid = true;
                        this.activateAdjblocks();
                        AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).setAtmosphereType(this, AtmosphereType.PRESSURIZEDAIR);
                    }
                } else if (this.hasFluid) {
                    AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension()).setAtmosphereType(this, DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.getDimension()).getAtmosphere());
                    this.deactivateAdjblocks();
                    this.hasFluid = false;
                }
            }
        }
    }

    @Override
    public int getTraceDistance() {
        return this.allowTrace ? this.radius : -1;
    }

    public void func_73660_a() {
        if (this.canPerformFunction()) {
            if (this.hasEnoughEnergy(this.getPowerPerOperation())) {
                this.performFunction();
                if (!this.field_145850_b.field_72995_K && this.isSealed) {
                    this.energy.extractEnergy(this.getPowerPerOperation(), false);
                }
            } else {
                this.notEnoughEnergyForFunction();
            }
        } else {
            this.radius = -1;
        }
        if (!this.soundInit && this.field_145850_b.field_72995_K) {
            LibVulpes.proxy.playSound((Object)new RepeatingSound(AudioRegistry.airHissLoop, SoundCategory.BLOCKS, (TileEntity)this));
        }
        this.soundInit = true;
    }

    private void setSealed(boolean sealed) {
        boolean prevSealed = this.isSealed;
        if (prevSealed != sealed) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            if (this.isSealed) {
                this.radius = -1;
            }
        }
        this.isSealed = sealed;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a("isSealed", this.isSealed);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.isSealed = tag.func_74767_n("isSealed");
        if (this.isSealed) {
            this.activateAdjblocks();
        }
    }

    public float getGasUsageMultiplier() {
        return (float)((double)Math.max(0.01f - (float)this.numScrubbers * 0.005f, 0.0f) * Configuration.oxygenVentConsumptionMult);
    }

    public void notEnoughEnergyForFunction() {
        if (!this.field_145850_b.field_72995_K) {
            AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.getDimension());
            if (handler != null) {
                handler.clearBlob(this);
            }
            this.deactivateAdjblocks();
            this.setSealed(false);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canBlobsOverlap(HashedBlockPosition blockPosition, AreaBlob blob) {
        return false;
    }

    @Override
    public int getMaxBlobRadius() {
        return Configuration.oxygenVentSize;
    }

    @Override
    public HashedBlockPosition getRootPosition() {
        return new HashedBlockPosition(this.field_174879_c);
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        ArrayList<ModuleBase> modules = new ArrayList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this));
        modules.add((ModuleBase)new ModuleLiquidIndicator(32, 20, (IFluidHandler)this));
        modules.add((ModuleBase)this.redstoneControl);
        modules.add((ModuleBase)this.traceToggle);
        return modules;
    }

    public String getModularInventoryName() {
        return "OxygenVent";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean canFormBlob() {
        return this.getEquivilentPower();
    }

    public boolean isRunning() {
        return this.isSealed;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 2) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        }
        if (buttonId == 3) {
            this.allowTrace = this.traceToggle.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 3));
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 2) {
            out.writeByte(this.state.ordinal());
        } else if (id == 3) {
            out.writeBoolean(this.allowTrace);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 2) {
            nbt.func_74774_a("state", in.readByte());
        } else if (packetId == 3) {
            nbt.func_74757_a("trace", in.readBoolean());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 2) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        } else if (id == 3) {
            this.allowTrace = nbt.func_74767_n("trace");
            if (!this.allowTrace) {
                this.radius = -1;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        this.allowTrace = nbt.func_74767_n("allowtrace");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        nbt.func_74757_a("allowtrace", this.allowTrace);
        return nbt;
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void stateUpdated(ModuleBase module) {
        if (module.equals(this.traceToggle)) {
            this.allowTrace = ((ModuleToggleSwitch)module).getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 3));
        }
    }
}

