/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.satellite;

import net.minecraft.nbt.NBTTagCompound;

public class SatelliteProperties {
    private int powerGeneration;
    private int powerStorage;
    private int maxData;
    private long id = -1L;
    private String satType = null;

    public SatelliteProperties() {
    }

    public SatelliteProperties(int powerGeneration, int powerStorage, String satType, int maxData) {
        this();
        this.powerGeneration = powerGeneration;
        this.powerStorage = powerStorage;
        this.satType = satType;
        this.maxData = maxData;
    }

    public int getPropertyFlag() {
        int flag = 0;
        if (this.satType != null) {
            flag |= Property.MAIN.getFlag();
        }
        if (this.powerGeneration != 0) {
            flag |= Property.POWER_GEN.getFlag();
        }
        if (this.powerStorage != 0) {
            flag |= Property.BATTERY.getFlag();
        }
        if (this.maxData != 0) {
            flag |= Property.DATA.getFlag();
        }
        return flag;
    }

    public long getId() {
        return this.id;
    }

    public boolean setId(long id) {
        if (this.id == -1L) {
            this.id = id;
            return true;
        }
        return false;
    }

    public SatelliteProperties setPowerGeneration(int powerGeneration) {
        this.powerGeneration = powerGeneration;
        return this;
    }

    public int getPowerGeneration() {
        return this.powerGeneration;
    }

    public SatelliteProperties setPowerStorage(int powerStorage) {
        this.powerStorage = powerStorage;
        return this;
    }

    public int getPowerStorage() {
        return this.powerStorage;
    }

    public SatelliteProperties setMaxData(int maxData) {
        this.maxData = maxData;
        return this;
    }

    public int getMaxDataStorage() {
        return this.maxData;
    }

    public SatelliteProperties setSatelliteType(String type) {
        this.satType = type;
        return this;
    }

    public String getSatelliteType() {
        return this.satType;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("powerGeneration", this.powerGeneration);
        nbt.func_74768_a("powerStorage", this.powerStorage);
        nbt.func_74778_a("dataType", this.satType);
        nbt.func_74772_a("satId", this.id);
        nbt.func_74768_a("maxData", this.maxData);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.powerGeneration = nbt.func_74762_e("powerGeneration");
        this.powerStorage = nbt.func_74762_e("powerStorage");
        this.satType = nbt.func_74779_i("dataType");
        this.id = nbt.func_74763_f("satId");
        this.maxData = nbt.func_74762_e("maxData");
    }

    public static enum Property {
        MAIN,
        DATA,
        POWER_GEN,
        BATTERY;


        public int getFlag() {
            return 1 << this.ordinal();
        }

        public boolean isOfType(int flag) {
            return (flag & this.getFlag()) != 0;
        }
    }
}

