/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.dimension.solar;

import java.util.List;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;

public class Planet {
    private int dimId;
    private StellarBody star;
    private List<Planet> moons;
    private List<SatelliteBase> satallites;
    private List<SatelliteBase> tickingSatallites;
    private double orbit;

    public Planet(StellarBody star, int dimId) {
        this.star = star;
    }

    public void addMoon(Planet moon) {
        this.moons.add(moon);
    }

    public void addSatallite(SatelliteBase satallite) {
        this.satallites.add(satallite);
        if (satallite.canTick()) {
            this.tickingSatallites.add(satallite);
        }
    }

    public boolean removeSatallite(SatelliteBase satallite) {
        if (satallite.canTick()) {
            this.tickingSatallites.remove(satallite);
        }
        return this.satallites.remove(satallite);
    }

    public List<SatelliteBase> getSatallites() {
        return this.satallites;
    }

    public void tick() {
        for (SatelliteBase satallite : this.tickingSatallites) {
            satallite.tickEntity();
        }
    }

    public StellarBody getStar() {
        return this.star;
    }

    public int getDimensionId() {
        return this.dimId;
    }

    public List<Planet> getMoons() {
        return this.moons;
    }
}

