/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PropertyContainer
implements IPropertyContainer {
    private NBTTagCompound nbtInfo = new NBTTagCompound();

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        if (prop == null) {
            return null;
        }
        return this.getProperty(prop, prop.getDefault());
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        if (prop == null) {
            return null;
        }
        NBTTagCompound jProp = this.getDomain(prop.getKey());
        if (!jProp.func_74764_b(prop.getKey().func_110623_a())) {
            return def;
        }
        return prop.readValue(jProp.func_74781_a(prop.getKey().func_110623_a()));
    }

    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        if (prop == null) {
            return false;
        }
        return this.getDomain(prop.getKey()).func_74764_b(prop.getKey().func_110623_a());
    }

    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        if (prop == null || value == null) {
            return;
        }
        NBTTagCompound dom = this.getDomain(prop.getKey());
        dom.func_74782_a(prop.getKey().func_110623_a(), prop.writeValue(value));
        this.nbtInfo.func_74782_a(prop.getKey().func_110624_b(), (NBTBase)dom);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_179237_a(this.nbtInfo);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.nbtInfo = new NBTTagCompound();
        this.nbtInfo.func_179237_a(nbt);
    }

    private NBTTagCompound getDomain(ResourceLocation res) {
        return this.nbtInfo.func_74775_l(res.func_110624_b());
    }
}

