/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.ILifeDatabase;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.QuestSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public final class LifeDatabase
implements ILifeDatabase {
    public static final LifeDatabase INSTANCE = new LifeDatabase();
    private final HashMap<UUID, Integer> playerLives = new HashMap();
    private final HashMap<Integer, Integer> partyLives = new HashMap();

    @Override
    public int getLives(UUID uuid) {
        if (uuid == null) {
            return 0;
        }
        if (this.playerLives.containsKey(uuid)) {
            return this.playerLives.get(uuid);
        }
        int def = QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_DEF);
        this.playerLives.put(uuid, def);
        return def;
    }

    @Override
    public void setLives(UUID uuid, int value) {
        if (uuid == null) {
            return;
        }
        this.playerLives.put(uuid, MathHelper.func_76125_a((int)value, (int)0, (int)QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_MAX)));
    }

    @Override
    public int getLives(IParty party) {
        int id;
        int n = id = party == null ? -1 : PartyManager.INSTANCE.getID(party);
        if (id < 0) {
            return 0;
        }
        if (this.partyLives.containsKey(id)) {
            return this.partyLives.get(id);
        }
        int def = QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_DEF);
        this.partyLives.put(id, def);
        return def;
    }

    @Override
    public void setLives(IParty party, int value) {
        int id;
        int n = id = party == null ? -1 : PartyManager.INSTANCE.getID(party);
        if (id < 0) {
            return;
        }
        this.partyLives.put(id, MathHelper.func_76125_a((int)value, (int)0, (int)QuestSettings.INSTANCE.getProperty(NativeProps.LIVES_MAX)));
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("lives", (NBTBase)this.writeProgressToNBT(new NBTTagCompound(), (List<UUID>)null));
        tags.func_74782_a("data", (NBTBase)base);
        return new QuestingPacket(PacketTypeNative.LIFE_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        NBTTagCompound base = payload.func_74775_l("data");
        this.readProgressFromNBT(base.func_74775_l("lives"), false);
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jul = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : this.playerLives.entrySet()) {
            NBTTagCompound j = new NBTTagCompound();
            j.func_74778_a("uuid", entry.getKey().toString());
            j.func_74768_a("lives", entry.getValue().intValue());
            jul.func_74742_a((NBTBase)j);
        }
        json.func_74782_a("playerLives", (NBTBase)jul);
        NBTTagList jpl = new NBTTagList();
        for (Map.Entry<Integer, Integer> entry : this.partyLives.entrySet()) {
            NBTTagCompound j = new NBTTagCompound();
            j.func_74768_a("partyID", entry.getKey().intValue());
            j.func_74768_a("lives", entry.getValue().intValue());
            jpl.func_74742_a((NBTBase)j);
        }
        json.func_74782_a("partyLives", (NBTBase)jpl);
        return json;
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        int lives;
        NBTTagCompound j;
        int i;
        this.playerLives.clear();
        NBTTagList tagList = json.func_150295_c("playerLives", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            j = tagList.func_150305_b(i);
            try {
                UUID uuid = UUID.fromString(j.func_74779_i("uuid"));
                lives = j.func_74762_e("lives");
                this.playerLives.put(uuid, lives);
                continue;
            }
            catch (Exception uuid) {
                // empty catch block
            }
        }
        this.partyLives.clear();
        tagList = json.func_150295_c("partyLives", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            j = tagList.func_150305_b(i);
            int partyID = j.func_150297_b("partyID", 99) ? j.func_74762_e("partyID") : -1;
            lives = j.func_74762_e("lives");
            if (partyID < 0) continue;
            this.partyLives.put(partyID, lives);
        }
    }

    @Override
    public void reset() {
        this.playerLives.clear();
        this.partyLives.clear();
    }
}

